<?php 
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");
require_once("../etc/templateAdeudoCliente.php");
require('../TCPDF/tcpdf.php');


if(isset($_GET['IDCLIENTE']) && $_GET['IDCLIENTE'] > 0){
	$clienteId = intval($_GET['IDCLIENTE']);
}

 // Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo_example.jpg';
        $this->Image('@'.$image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 15, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		$colorcuadros = "#84849c";
		
        $this->SetY(-12);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Pag. '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetTextColor(114,114, 114);
		 
		    $uno = hexdec(substr($colorcuadros,-6,2));
			$dos = hexdec(substr($colorcuadros,-4,2));
			$tres = hexdec(substr($colorcuadros,-2));
			
			$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array($uno, $dos, $tres)));
			$this->RoundedRect(5, 5, 200, 282, 3.50, '1111', 'D');
		 
			$this->Cell(0, 10, 'By www.xnet.mx', 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

 
$tcpdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, false, 'ISO-8859-1', false);  

$tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set title of pdf
$tcpdf->SetTitle("Estado de cuenta cliente");

// set margins
$tcpdf->SetMargins(10, 10, 10, 10);
$tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set header and footer in pdf
$tcpdf->setPrintHeader(false);
$tcpdf->setPrintFooter(true);
$tcpdf->setListIndentWidth(3);

// set auto page breaks
$tcpdf->SetAutoPageBreak(TRUE, 15);

// set image scale factor
$tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

$tcpdf->AddPage();

$template = getAdeudosTable($clienteId, $_SESSION["IDORIGEN"]);
$html = '<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
'.$template.'
</body>
</html>';

$tcpdf->writeHTML($html, true, false, false, false, '');


if(isset($_GET['IDCLIENTE']) && $_GET['IDCLIENTE'] > 0){
  //$pdf->Output($tipod.".pdf","D");
  ob_end_clean();
  $tcpdf->Output("EstadoCta".intval($_GET['IDCLIENTE']).'.pdf', 'D');
  exit;
}
//$tcpdf->Output($_SERVER['DOCUMENT_ROOT']."/system/facts/factura".$row_ords['NUMERO_FACT'].".pdf","F");
$fileatt = $tcpdf->Output($_SERVER['DOCUMENT_ROOT'].'/system/temp/EstadoCta'.$clienteId.'.pdf', 'F');

$selectLogo = sprintf("SELECT LOGO FROM TBL_ORIGEN WHERE IDORIGEN = %s",
					  GetSQLValueString($_SESSION["IDORIGEN"], "int"));
$rsLogo = mysql_query($selectLogo) or die(mysql_error());
$logo = mysql_fetch_assoc($rsLogo)["LOGO"];


//Cliente
$selectcliente = sprintf("SELECT NOMBRE FROM TBL_CLIENTES WHERE IDCTE = %s",
					  GetSQLValueString($clienteId, "int"));
$rscliente = mysql_query($selectcliente) or die(mysql_error());
$row_cliente = mysql_fetch_assoc($rscliente);

$cliente = $row_cliente["NOMBRE"];

$time = date("a");
$greeting = "";

if ($time == 'am') {
	$greeting = "Buenos d&iacute;as";
} else {
	if (date('h') < 18) {
		$greeting = "Buenas tardes";
	} else {
		$greeting = "Buenas noches";
	}
}

$mes = "";
if(date("m") == "01"){$mes = "Enero";}
if(date("m") == "02"){$mes = "Febrero";}
if(date("m") == "03"){$mes = "Marzo";}
if(date("m") == "04"){$mes = "Abril";}
if(date("m") == "05"){$mes = "Mayo";}
if(date("m") == "06"){$mes = "Junio";}
if(date("m") == "07"){$mes = "Julio";}
if(date("m") == "08"){$mes = "Agosto";}
if(date("m") == "09"){$mes = "Septiembre";}
if(date("m") == "10"){$mes = "Octubre";}
if(date("m") == "11"){$mes = "Noviembre";}
if(date("m") == "12"){$mes = "Diciembre";}

$fecha = date("d")." de ".$mes." de ".date("Y");

$adjuntos = array(
			  array("NOMBRE" => "EstadoCta.pdf", "URL" => $_SERVER['DOCUMENT_ROOT'].'/system/temp/EstadoCta'.$clienteId.'.pdf')
			);

$resultadoCorreo = mandaCorreo($correos, "Estado de Cuenta", $greeting.", <br><br>Adjunto encontrará el estado de cuenta de ".$cliente." actualizado al día de hoy, ".$fecha.".<br><br>Si tuviera algún comprobante de estas facturas favor de hacerlo llegar a este correo aalvidrez@agromalpa.com.mx.<br><br>Sin más por el momento, me reitero a sus ordenes por cualquier duda o comentario.<br><br>Muchas gracias. Saludos cordiales", '../'.$logo, $adjuntos);

unlink($_SERVER['DOCUMENT_ROOT'].'/system/temp/EstadoCta'.$clienteId.'.pdf');

?>