<?php

require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");

header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=Saldos Proveedores.xls");  //File name extension was wrong
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: private", false);

if (!function_exists("ejecutarQuery")) {
  function ejecutarQuery($query)
  {
    global $xnet;
    global $database_xnet;
    mysql_select_db($database_xnet, $xnet);
    $res = mysql_query($query, $xnet);
    return $res;
  }
}

if (!function_exists("getResultQuery")) {
  function getResultQuery($query, $encode = array())
  {
    global $xnet;
    global $database_xnet;
    mysql_select_db($database_xnet, $xnet);
    $res = mysql_query($query, $xnet) or die(mysql_error());
    $result = array();
    while ($r = mysql_fetch_assoc($res)) {
      foreach ($encode as $kee) {
        if (array_key_exists($kee, $r)) {
          $r[$kee] = utf8_encode(utf8_decode($r[$kee]));
        }
      }
      array_push($result, $r);
    }
    return $result;
  }
}

function stringStartsWith($needle, $haystack)
{
  if (strpos($haystack, $needle) === 0) {
    return true;
  } else {
    return false;
  }
}

?>

<style>
  table,
  th {
    border: 1px solid #ccc;
    border-collapse: collapse;
  }

  .tableHeader {
    background-color: #0C0;
    color: white;
    font-weight: bold;
    padding: 5px;
  }

  .evenRow {
    background-color: #fbe7fa;
  }

  td {
    padding: 15px;
  }
</style>


<!--QUERY-->
<?php
$query = sprintf(
  "SELECT 
  TM.MONEDA,
  SUM(TH.SALDO_OC) AS MONTOTOTAL,
  SUM(TH.MONTO_TOTAL) AS MONTO_TOTAL,
  TH.IDPROVEEDOR,
  TPP.NOMBRE AS PROVEEDOR,
  TH.IDORDEN
  FROM TBL_ORDENES_COMPRA_HEADER TH
  LEFT JOIN TBL_PROVEEDORES TPP ON TPP.IDPROVEEDOR=TH.IDPROVEEDOR
  LEFT JOIN TBL_MONEDAS TM ON TM.IDMONEDA = TH.IDMONEDA
  WHERE %s
  GROUP BY TH.IDPROVEEDOR, TM.MONEDA %s %s",
  $filtros,
  $having,
  $ord
);
$proveedores = getResultQuery($query);
?>

<h3>Reporte de proveedores</h3>

<table class="uk-table dataTable" cellspacing="0" width="100%" style="font-size: 14px;">
  <thead>
    <tr>
      <th align="center" class="tableHeader">PROVEEDOR</th>
      <th align="center" class="tableHeader">OC</th>
      <th align="center" class="tableHeader">FOLIO</th>
      <th align="center" class="tableHeader">FECHA</th>
      <th align="center" class="tableHeader">MONTO TOTAL</th>
      <th align="center" class="tableHeader">SALDO</th>
    </tr>
  </thead>
  <tbody>
    <?php if (count($proveedores) > 0) { ?>
      <?php foreach ($proveedores as $proveedor) { ?>
        <tr>
          <td class="tableHeader" style="background-color: #69F;text-align: center;"><?php echo $proveedor["PROVEEDOR"]; ?></td>
          <td class="tableHeader" style="background-color: #69F;text-align: center;">-</td>
          <td class="tableHeader" style="background-color: #69F;text-align: center;">-</td>
          <td class="tableHeader" style="background-color: #69F;text-align: center;">-</td>
          <td class="tableHeader" style="background-color: #69F;text-align: center;"><?php echo "$" . number_format($proveedor["MONTO_TOTAL"], 2) . " " . $proveedor["MONEDA"]; ?></td>
          <td class="tableHeader" style="background-color: #69F;text-align: center;"><?php echo "$" . number_format($proveedor["MONTOTOTAL"], 2) . " " . $proveedor["MONEDA"]; ?></td>
        </tr>
        <?php
        if (!stringStartsWith("AND", trim($filtros))) {
          $filtros = "AND " . $filtros;
        }
       
        $query_detalles = sprintf(
          "SELECT 
          TM.MONEDA,
          TH.SALDO_OC AS SALDO,
          TH.IDPROVEEDOR,
          TH.FOLIO AS NUMERO,
          TH.IDORDEN,
          TH.FECHA_CREO AS FECHA,
          TH.MONTO_TOTAL AS MONTOTOTAL
          FROM TBL_ORDENES_COMPRA_HEADER TH
          LEFT JOIN TBL_PROVEEDORES TPP ON TPP.IDPROVEEDOR=TH.IDPROVEEDOR
          LEFT JOIN TBL_MONEDAS TM ON TM.IDMONEDA = TH.IDMONEDA
          WHERE 
          TH.IDPROVEEDOR=%s AND TM.MONEDA=%s {$filtros}
          ORDER BY TH.IDORDEN DESC",
          GetSQLValueString($proveedor["IDPROVEEDOR"], "int"),
          GetSQLValueString($proveedor["MONEDA"], "text")
        );

        $detalles = getResultQuery($query_detalles);
        ?>
        <?php foreach ($detalles as $detalle) { ?>
          <tr>
            <td style="text-align: center;"><?php echo $detalle['PROVEEDOR']; ?></td>
            <td style="text-align: center;"><?php echo $detalle['IDORDEN']; ?></td>
            <td style="text-align: center;"><?php echo $detalle['NUMERO']; ?></td>
            <td style="text-align: center;"><?php echo $detalle['FECHA']; ?></td>
            <td style="text-align: center;">$<?php echo number_format($detalle['MONTOTOTAL'], 2) . " " . $detalle['MONEDA']; ?></td>
            <td style="text-align: center;">$<?php echo number_format($detalle['SALDO'], 2) . " " . $detalle['MONEDA']; ?></td>
          </tr>
        <?php } ?>
      <?php } ?>
    <?php } else { ?>
      <tr>
        <td colspan="5" style="text-align:center;">No se han encontrado resultados</td>
      </tr>
    <?php } ?>
  </tbody>
</table>