<?php
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/FuntionsLibrary.php");
require_once("../requires/xnet.php");

$query_suc = sprintf("SELECT O.IDORIGEN, O.NOMBRE FROM TBL_ORIGEN O ORDER BY O.NOMBRE ASC");
$sucursales = getResultQuery($query_suc, array("NOMBRE"));

define('safe_access', true);
//include('php/variables.php');
?>



<div class="md-card uk-margin-medium-bottom">
    <div class="md-card-content">
      
        <form id="filtro_1" onsubmit="return false;">
            <br />
            <div class="uk-grid">
                <div class="uk-width-1-4">
                    <label style="font-size: 12px; color: gray; position: absolute; margin-top: -1%; z-index: 5;" for="IDORIGEN">Sucursal</label>
                    <select id="IDORIGEN" name="IDORIGEN" data-md-selectize>
                        <option value="@">Todos</option>
                        <?php foreach ($sucursales as $sucursal) { ?>
                            <option value="<?php echo $sucursal["IDORIGEN"] ?>"><?php echo $sucursal["NOMBRE"] ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="uk-width-1-4">
                    <label style="font-size: 12px; color: gray; position: absolute; margin-top: -1%; z-index: 5;" for="ANIO">A&ntilde;o</label>
                    <select name="ANIO" id="ANIO" data-md-selectize>
                        <option value="@">Todos</option>
                        <?php $anioac = date('Y'); ?>
                        <?php for ($i = 0; $i <= 5; $i++) { ?>
                            <option <?php if($anioac == $anioac - 2 + $i){echo "selected";} ?> value="<?php echo $anioac - 2 + $i; ?>"><?php echo $anioac - 2 + $i; ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="uk-width-1-4">
                    <label style="font-size: 12px; color: gray; position: absolute; margin-top: -1%; z-index: 5;" for="MES">Mes</label>
                    <?php $ELMES = date('m'); ?>
                    <select name="MES" id="MES" data-md-selectize>
                        <option value="@">Todos</option>
                        <option value="01" <?php if (!(strcmp("01", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Ene</option>
                        <option value="02" <?php if (!(strcmp("02", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Feb</option>
                        <option value="03" <?php if (!(strcmp("03", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Mar</option>
                        <option value="04" <?php if (!(strcmp("04", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Abr</option>
                        <option value="05" <?php if (!(strcmp("05", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>May</option>
                        <option value="06" <?php if (!(strcmp("06", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Jun</option>
                        <option value="07" <?php if (!(strcmp("07", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Jul</option>
                        <option value="08" <?php if (!(strcmp("08", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Ago</option>
                        <option value="09" <?php if (!(strcmp("09", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Sep</option>
                        <option value="10" <?php if (!(strcmp("10", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Oct</option>
                        <option value="11" <?php if (!(strcmp("11", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Nov</option>
                        <option value="12" <?php if (!(strcmp("12", $ELMES))) {echo "selected=\"selected\"";} 
                                            ?>>Dic</option>
                    </select>
                </div>
                <div class="uk-width-1-4" align="center" style="padding:13px;">
                    <a style="padding:2px 8px;" href="javascript:void(0)" class="md-btn md-btn-success uk-width-1-1" title="Filtrar" onClick="filtra();"><span class="fa fa-search"></span> Filtrar</a>
                </div>
               
               </div>
               <div class="uk-grid">
                <div class="uk-width-1-4" align="center">
                    <button type="button" id="btnNuevo" onclick="exportar()" class="md-btn md-btn-success uk-width-1-1"><span class="fa fa-download"></span> EXPORTAR </button>
                </div>
                 <div class="uk-width-1-4" align="center">
                 	<a class="md-btn md-btn-primary uk-width-1-1" onclick="abreTexto()" href="javascript: void(0);"><span class="fa fa-lightbulb"></span> Acerca de</a>
                 </div>
            </div>
        </form>
        <div class="uk-grid">
            <div class="uk-width-3-5" style="">
                <div id="dt_default_filter" class="dataTables_filter">
                    <div class="md-input-wrapper">
                        <div id="totales"></div>

                    </div>
                </div>
            </div>
        </div>
        <div id="grid"></div>
    </div>
</div>

<script>
    function params(formulario) {
        var parametros = "";
        if (document.getElementById(formulario) != undefined) {
            var formFields = document.getElementById(formulario).elements;
            if (formFields != null) {
                for (var i = 0; i < formFields.length; i++) {
                    var field = formFields[i];
                    //console.log(field.attributes.isrequired.value);
                    if (field.name != "" && field.name != null) {
                        if (field.type == "text" || field.type == "number" || field.type == "select-one" || field.type == "file" || field.type == "textarea") {
                            var value = $("#" + field.id).val();
                            parametros += `${field.name}=${value}&`;
                        }
                    }
                }
            }
        }
        return parametros.substring(0, parametros.length - 1);
    }

    function cargaContenidoUs(que, donde) {
        altair_helpers.content_preloader_show('md');
        $.ajax({
            type: "GET",
            url: que,
            cache: true,
            success: function(data) {
                $("#" + donde).html(data);
                altair_helpers.content_preloader_hide();

            }
        });

    }

    //acion generica de modificacion de grid
    function accion(vurl, forma, msg) {
        var form = $('#' + forma);
        $.ajax({
            type: "POST",
            url: vurl,
            data: form.serialize(),
            success: function(response) {
                alerta(msg);
                //act_grid();
                //filtra();
            }
        });
    }

    var latabla = "CD";
    var lacolumna = "IDCOTDET";
    var laad = "DESC";

    //filtro 
    function filtra(tabla, columna, ad) {
        var donde = "grid";
        var que = "grid/grid_reporte_comisiones.php";
        //var cuantos = document.getElementById("CUANTOS").value;

        var columnas = "";
        var fsaldo = document.getElementById("FMONTOTOTAL").value;
       // var fmoneda = document.getElementById("FMONEDA").value;
        var fnombre = document.getElementById("FNOMBRE").value;

        if (fsaldo != "" || fsaldo != null) {
            columnas = columnas + "&FMONTOTOTAL=" + fsaldo;
        }
     /*   if (fmoneda != "" || fmoneda != null) {
            columnas = columnas + "&FMONEDA=" + fmoneda;
        }*/
        if (fnombre != "" || fnombre != null) {
            columnas = columnas + "&FNOMBRE=" + fnombre;
        }

        var filtro = params("filtro_1");
        filtro += (params("filtro_2") != "") ? "&" + params("filtro_2") : "";
        filtro = filtro != "" ? "?" + filtro : "";


        cargaContenidoUs(encodeURI("grid/grid_reporte_comisiones.php" + filtro+columnas+"&COLUMNA="+columna+"&AD="+ad+"&TABLA="+tabla), "grid");

        latabla = tabla;
        lacolumna = columna;
        laad = ad;

        // cargaContenidoUs(que+'?T='+Math.random()+columnas+"&COLUMNA="+columna+"&AD="+ad+"&TABLA="+tabla+'&DESDE='+encodeURI(document.getElementById("DESDE").value)+'&HASTA='+encodeURI(document.getElementById("HASTA").value), donde); 
    }


    function pasa(tabla, columna) {
        var or = $("#I" + tabla + columna).val();
        //alert(or+' #I'+tabla+columna);
        if (or == 0) {
            //El valor 1 es ASC
            $("#I" + tabla + columna).val(1);
            or = $("#I" + tabla + columna).val();
            filtra(tabla, columna, or);
        } else {
            //El valor 0 es DESC
            $("#I" + tabla + columna).val(0);
            or = $("#I" + tabla + columna).val();
            filtra(tabla, columna, or);
        }
    }

    function activos() {
        var ac = $("#ACTIVOS").val();
        //0 es inactivos
        if (ac == 1) {
            $("#ACTIVOS").val(0);
        } else {
            $("#ACTIVOS").val(1);
        }
        filtra();
    }

    function cargaContenidoUs(que, donde) {
        altair_helpers.content_preloader_show('md');
        $("#" + donde).load(que, function() {
            altair_helpers.content_preloader_hide();
            cargaTotales();
        });

    }

    var idorigen = $("#IDORIGEN").val();
    var anio = $("#ANIO").val();
    var mes = $("#MES").val();
    cargaContenidoUs(encodeURI("grid/grid_reporte_comisiones.php?IDORIGEN=" + idorigen + "&ANIO=" + anio + "&MES=" + mes), "grid");
    //alerta("Entre a la pagina", "success", "bottom-right");


    $(document).ready(function() {
        //function onOpen(){
        //$(".k-calendar-container").parent().css("zIndex", "11000");	
        //		}   

        // $("#datepicker").kendoDatePicker({

        //              open: onOpen
        //          });
    });

    function nuevo() {
        var myWindow = $("#window2");

        myWindow.kendoWindow({
            width: "100%",
            title: "Nueva Propiedad",
            content: "nueva_propiedad.php",
            draggable: false,
            visible: false,
            iframe: false,
            cache: true,
            close: function() {}
        }).data("kendoWindow");

        myWindow.data("kendoWindow").content("Cargando...").open();
        var myWindows2m = $("#window2").data("kendoWindow");
        myWindows2m.maximize();
    }


    function abrir(id) {
        var myWindow2 = $("#window2");
        myWindow2.kendoWindow({
            width: "100%",
            title: "Editar Propiedad",
            content: "editar_propiedad.php?ID=" + id,
            type: "GET",
            draggable: false,
            iframe: false,
            cache: true,
            close: function() {}
        });
        myWindow2.data("kendoWindow").content("Cargando...").open(); // open the window
        var myWindows2m = $("#window2").data("kendoWindow");
        myWindows2m.maximize();

    }

    function inactiva(id, tipo) {
        //alerta(id+" "+tipo, 'success', 'top-center');
        var msj = "";
        if (tipo == 1) {
            msj = "Deseas volver a activar esta propiedad?";
        } else {
            msj = "Deseas inactivar esta propiedad?";
        }
        UIkit.modal.confirm(msj,
            function() {
                $.ajax({
                    type: "GET",
                    url: "inactivapropiedades.php?ID=" + id + "&TIPO=" + tipo,
                    success: function(response) {
                        //alert(response);
                        alerta(response, "info", "top-center");
                        filtra();
                    }
                });
            });
    }

    function cargaTotales() {


    }


    function exportar(tabla, columna, ad) {
        var donde = "grid";
        var que = "grid/grid_reporte_comisiones.php";
        //var cuantos = document.getElementById("CUANTOS").value;

        var columnas = "";
        var fsaldo = null;
        //var fmoneda = document.getElementById("FMONEDA").value;
        var fnombre = document.getElementById("FNOMBRE").value;
        var fmonto_total = document.getElementById("FMONTOTOTAL").value;

      /*  if (fsaldo != "" || fsaldo != null) {
            columnas = columnas + "&FSALDO=" + fsaldo;
        }*/
       /* if (fmoneda != "" || fmoneda != null) {
            columnas = columnas + "&FMONEDA=" + fmoneda;
        }*/
        if (fnombre != "" || fnombre != null) {
            columnas = columnas + "&FNOMBRE=" + fnombre;
        }
        if (fnombre != "" || fnombre != null) {
            columnas = columnas + "&FMONTOTOTAL=" + fmonto_total;
        }

        var idorigen = $("#IDORIGEN").val();
        var anio = $("#ANIO").val();
        var mes = $("#MES").val();

        location.href = encodeURI(que+"?XLS=1&IDORIGEN=" + idorigen + "&ANIO=" + anio + "&MES=" + mes + "&COLUMNA=" + columna + "&AD=" + ad + "&TABLA=" + tabla + columnas);


        latabla = tabla;
        lacolumna = columna;
        laad = ad;

        // cargaContenidoUs(que+'?T='+Math.random()+columnas+"&COLUMNA="+columna+"&AD="+ad+"&TABLA="+tabla+'&DESDE='+encodeURI(document.getElementById("DESDE").value)+'&HASTA='+encodeURI(document.getElementById("HASTA").value), donde); 
    }
	
	function abreTexto(){
		var texto = "";
texto+= "*Las comisiones se calculan en base a la venta del producto y el costo del mismo<br />";
texto+= "*La venta del producto viene de la factura no cancelada<br />";
texto+= "*El costo viene de la OP (orden de producci&oacute;n), el cual se pone en automatico si la OP se pasa a produccion para descargar inventario, sacando el costo promedio que en el inventario se lleva cuando una OC se recibe, se puede configurar desde la OP si se desea modificar el costo<br />";
texto+= "*La utilidad se saca con la diferencia de la venta vs el costo<br />";
texto+= "*La comision se calcula con el % que tenga configurado el vendedor por la utilidad<br />";
texto+= "*Todos los montos estan en MXN, el tipo de cambio y la moneda de la venta se saca de la factura. El tipo de cambio y la moneda del costo se saca de la OP (orden de produccion), el cual es calculado automaticamente si la OP se convierte a orden de compra, se puede configurar en la OP si se desea cambiar este dato";	
		
		UIkit.modal.alert(texto);
		
	}
	
</script>