<?php
if (isset($_SESSION)) {
    $waitScreen = false;
} else {
    $waitScreen = true;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pantalla Cliente</title>

    <link rel="shortcut icon" href="../favicon.ico">

    <link rel="stylesheet" href="css/normalize.css">

    <!--  BOOTSTRAP -->
    <link rel="stylesheet" href="includes/bootstrap v5-3/css/bootstrap.min.css" integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">
    <script src="includes/bootstrap v5-3/js/bootstrap.min.js"></script>
    <script src="includes/bootstrap v5-3/js/bootstrap.bundle.min.js"></script>

    <!-- <script src="https://cdn.jsdelivr.net/npm/swiper@10.2.0/swiper-bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/swiper@10.2.0/swiper-bundle.min.css" rel="stylesheet"> -->

    <link href="assets/css/vendor.min.css" rel="stylesheet">

    <link rel="stylesheet" href="css/themes/default/jquery.mobile-1.4.2.min.css">
    <link rel="stylesheet" href="css/keyboard.css">
    <link rel="stylesheet" href="css/pantallas.css">

    <script src="js/libs/jquery/jquery-3.7.0.min.js"></script>
    <script type="text/javascript" src="includes/template7/template7.min.js"></script>

    <style>

        div {
            margin: 0;
            padding: 0;
        }

        hr {
            margin: 0;
            padding: 0;
        }

        h2 {
            margin-top: 10px;
            font-size: 15px;
            font-weight: 500;
            padding-bottom: 10px;
        }

        #pantallaCliente {
            margin: auto;
            position: absolute;
            top: 90px;
            bottom: 70px;
            width: 900px;
            left: 0;
            right: 0;
            border-radius: 20px;
            box-shadow: 0px 0px 20px 12px #33333321;
        }

        #linea_separador {
            position: absolute;
            height: 1px;
            width: 100%;
            background: #3333337d;
        }

        header,
        footer {
            min-width: 500px;
            margin-top: auto;
        }

        /* body {
            display:flex;
            flex-direction: column;
            min-height: 100vh;
            margin: 0;
        } */
    </style>
</head>

<body id="pantallaCompleta">


    {{#js_if "this.success == '1'"}}

        <header id="total" class="bg-light" style="filter: invert(1);">
            <nav>
                <div class="header_cocina_izq">
                    <div id="espera">
                        <h3 style="color: #000000; font-size: 30px">
                            TOTAL:<span style="font-size: 30px; font-weight: 700;"> ${{this.precio_total}}</span>
                        </h3>
                    </div>
                </div>
                <img src="img/jackface.svg" width="60" height="60" style="filter: invert(1);">
            </nav>
        </header>

        <div style="text-align: center;overflow-y: scroll;" id="pantallaCliente" class="bg-light">
            <div style="margin: 25px;">
                <div style="display: grid; grid-template-columns: 13% 48% 19% 19%; width: 100%; margin: auto; word-wrap: break-word;margin: 10px 0;">
                    <div>
                        <h1 style="font-size: 25px">Cantidad</h1>
                    </div>
                    <div>
                        <h1 style="font-size: 25px">Descripción</h1>
                    </div>
                    <div>
                        <h1 style="font-size: 25px">Precio Unitario</h1>
                    </div>
                    <div>
                        <h1 style="font-size: 25px">Precio Total</h1>
                    </div>
                </div>

                {{#each this.orden}}
                    {{#js_if "this.HEAD == '1'"}}
                        <div style="position: relative;display: grid; grid-template-columns: 13% 48% 19% 19%; grid-template-rows: 50% 50%; width: 100%; margin-top: -10px; word-wrap: break-word;">
                            <div id="linea_separador"></div>
                            <div>
                                <p style="font-size: 26px; font-weight">{{CANT}}</p>
                            </div>
                            <div>
                                <p style="text-align:left;font-size: 26px; font-weight: 700;">{{DESCRIPCION}} {{#js_if "this.TAM"}}<span style="font-size: 26px; font-weight: 700;">{{TAM}}</span>{{/js_if}} </p>
                            </div>
                            <div>
                                <p style="font-size: 26px">${{PUNIT}}</p>
                            </div>
                            <div>
                                <p style="font-size: 26px">${{PTOTAL}}</p>
                            </div>
                        </div>
                    {{/js_if}}
                    {{#js_if "this.HEAD == '0'"}}
                        <div style="display: grid; grid-template-columns: 13% 48% 19% 19%; grid-template-rows: 50% 50%; width: 100%; margin-top: -16px; word-wrap: break-word;">
                            <div>
                                <p></p>
                            </div>
                            <div>
                                <p style="text-align:left; padding-left: 40px;font-size: 24px;">- {{DESCRIPCION}}</p>
                            </div>
                            <div>
                                <p style="font-size: 24px">${{PUNIT}}</p>
                            </div>
                            <div>
                                <p style="font-size: 24px">${{PTOTAL}}</p>
                            </div>
                        </div>
                    {{/js_if}}
                {{/each}}
            </div>
        </div>

        <footer class="bg-light" style="height: 50px; filter: invert(1);">
            <nav>
                <div class="header_cocina_izq">
                    <div>
                        <img src="img/jack_footer.svg" height="40" style="filter: invert(1);">
                    </div>
                    <div>
                        <h5 style="margin: 0; font-size: 20px">Chihuahua, Chih</h5>
                    </div>
                </div>

            </nav>
        </footer>

    {{/js_if}}

    {{#js_if "this.success == '0'"}}

        <style>
            body {
                background-color: rgb(116, 63, 157);
            }

            h1 {
                color: white;
                margin-top: 50px;
                font-size: 45px;
                font-family: Roboto, "Helvetica Neue", sans-serif;
            }

            img {
                width: 500px;
            }

            div {
                margin-top: 100px
            }
        </style>

        <div style="text-align: center;">
            <img src="images/JackintheBoxLogo.png" alt="">
            <h1>Bienvenido a Jack in the box</h1>
        </div>


    {{/js_if}}


    <script>
        function scrollToBottom() {
            var scrollableDiv = document.getElementById("pantallaCliente");
            scrollableDiv.scrollTop = scrollableDiv.scrollHeight;
        }

        
    </script>
    <script>
        function getOrderScreen() {
            $.ajax({
                method: "GET",
                url: "pantallaServices.php?IPPANTALLA=<?php echo trim($_GET["ip"]) ?>",
                data: {
                    ACTION: "GETORDER"
                },
                error: function(response) {
                    setTimeout(() => {
                        getOrderScreen();
                    }, 5000);
                },
                success: function(data) {
                    try {
                        var res = JSON.parse(data);
                        console.log(res);

                        $$("#pantallaCompleta").renderT7({
                            context: res
                        });
                        scrollToBottom();

                        setTimeout(() => {
                            getOrderScreen();
                        }, 2000);

                    } catch (error) {
                        console.error(error);
                        setTimeout(() => {
                            getOrderScreen();
                        }, 2000);
                    }
                }
            });
        }
        getOrderScreen();
    </script>


</body>

</html>
