<?php

use Zend\Db\Sql\Where;

require_once('Connections/promo.php');

if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
    {
        if (PHP_VERSION < 6) {
            $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
        }

        $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

        switch ($theType) {
            case "text":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue != "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
                break;
            case "date":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
                break;
        }
        return $theValue;
    }
}

import React, { useState, useEffect } from 'react';

// Aquí defines un componente funcional para manejar la lógica de la sección de tamaños
const TamanioComponent = ({ idOrden, idProd, comboBb }) => {
  const [tamanio, setTamanio] = useState(null);

  useEffect(() => {
    // Aquí se emula la lógica de consulta de tamaños (simulado con setTimeout)
    const fetchTamanio = async () => {
      try {
        // Lógica de consulta de tamaños a la base de datos (puedes usar fetch o axios)
        // Simulación de espera de respuesta con setTimeout
        const response = await fetch('ruta_de_tu_api');
        const data = await response.json();

        // Actualiza el estado con los tamaños obtenidos
        setTamanio(data);
      } catch (error) {
        console.error('Error en la consulta:', error);
      }
    };

    fetchTamanio(); // Llamada a la función de consulta
  }, [idOrden, idProd, comboBb]);

  return (
    <div className="modificadoresCosas">
      {/* Lógica de renderizado de tamaños y botones */}
      {/* ... */}
    </div>
  );
};

// Aquí defines un componente funcional para manejar la lógica de la sección de modificadores
const ModificadoresComponent = ({ idProd, idOrden }) => {
  const [modificadores, setModificadores] = useState([]);

  useEffect(() => {
    // Aquí se emula la lógica de consulta de modificadores (simulado con setTimeout)
    const fetchModificadores = async () => {
      try {
        // Lógica de consulta de modificadores a la base de datos (puedes usar fetch o axios)
        // Simulación de espera de respuesta con setTimeout
        const response = await fetch('ruta_de_tu_api');
        const data = await response.json();

        // Actualiza el estado con los modificadores obtenidos
        setModificadores(data);
      } catch (error) {
        console.error('Error en la consulta:', error);
      }
    };

    fetchModificadores(); // Llamada a la función de consulta
  }, [idProd, idOrden]);

  return (
    <div className="modificadoresCosasDIV2 wrapper4" style={{ overflowY: 'auto' }}>
      {/* Lógica de renderizado de modificadores */}
      {/* ... */}
    </div>
  );
};

// Componente principal donde se utilizan los componentes anteriores
const MainComponent = () => {
  const ID_ORDEN = '...'; // Aquí establece el ID de orden deseado
  const ID_PROD = '...'; // Aquí establece el ID de producto deseado
  const COMBO_BB = '...'; // Aquí establece el valor de combo deseado

  return (
    <div>
      {/* Renderiza el componente de tamaños */}
      <TamanioComponent idOrden={ID_ORDEN} idProd={ID_PROD} comboBb={COMBO_BB} />
      
      {/* Renderiza el componente de modificadores */}
      <ModificadoresComponent idOrden={ID_ORDEN} idProd={ID_PROD} />
    </div>
  );
};

export default MainComponent;


                <script>
                    function moreItemSelect(idselected, vareable, compl, max) {
                        var char = parseInt(document.getElementById("miInp" + idselected + compl).value);
                        if (char < (max - 1)) {

                            var x = document.getElementById("miSelect" + idselected + compl);
                            var xy = x.options[x.selectedIndex];
                            var xyz = xy.value;
                            verificarOption(xyz, vareable);

                            document.getElementById("miSelect" + idselected + compl).selectedIndex = (char + 1);
                            document.getElementById("miInp" + idselected + compl).value = (char + 1);

                            var select = document.getElementById("miSelect" + idselected + compl);
                            var opcionSeleccionada = select.options[select.selectedIndex];
                            var idOption = opcionSeleccionada.value; // Obtener el valor de la opción
                            var textoOption = opcionSeleccionada.text;
                            var pecioOption = opcionSeleccionada.getAttribute("data-valmin");
                            subm5(idOption, textoOption, pecioOption, "", "", "");
                        }
                    }

                    function restItemSelect(idselected, vareable, compl, max) {
                        var char = parseInt(document.getElementById("miInp" + idselected + compl).value);
                        if (char > 0) {
                            var x = document.getElementById("miSelect" + idselected + compl);
                            var xy = x.options[x.selectedIndex];
                            var xyz = xy.value;
                            verificarOption(xyz, vareable);

                            document.getElementById("miSelect" + idselected + compl).selectedIndex = (char - 1);
                            document.getElementById("miInp" + idselected + compl).value = (char - 1);

                            var select = document.getElementById("miSelect" + idselected + compl);
                            var opcionSeleccionada = select.options[select.selectedIndex];
                            var idOption = opcionSeleccionada.value; // Obtener el valor de la opción
                            var textoOption = opcionSeleccionada.text;
                            var pecioOption = opcionSeleccionada.getAttribute("data-valmin");
                            subm5(idOption, textoOption, pecioOption, "", "", "");
                        }
                    }
                    const wrapper4 = document.querySelector('.wrapper4');
                    let isPressed4 = false;
                    let startY4 = 0;
                    let startScrollTop4 = 0;

                    function handleMouseDown4(e) {
                        isPressed4 = true;
                        startY4 = e.clientY;
                        startScrollTop4 = wrapper4.scrollTop;
                        wrapper4.style.cursor = 'grabbing';
                    }

                    function handleMouseLeave4() {
                        isPressed4 = false;
                        wrapper4.style.cursor = 'grab';
                    }

                    function handleMouseUp4() {
                        isPressed4 = false;
                        wrapper4.style.cursor = 'grab';
                    }

                    function handleMouseMove4(e) {
                        if (!isPressed4) {
                            return;
                        }
                        const deltaY = startY4 - e.clientY;
                        wrapper4.scrollTop = startScrollTop4 + deltaY;
                    }

                    wrapper4.addEventListener('mousedown', handleMouseDown4);
                    wrapper4.addEventListener('mouseleave', handleMouseLeave4);
                    window.addEventListener('mouseup', handleMouseUp4);
                    wrapper4.addEventListener('mousemove', handleMouseMove4);
                </script>