<?php 
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");
require_once("../etc/templateCorteDiaPagos.php");
require('../TCPDF/tcpdf.php');


if(isset($_GET['IDCORTE']) && $_GET['IDCORTE'] > 0){
	$corteId = intval($_GET['IDCORTE']);
}

 // Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo_example.jpg';
        $this->Image('@'.$image_file, 10, 10, 15, '', 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
        // Title
        $this->Cell(0, 15, '<< TCPDF Example 003 >>', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
		$colorcuadros = "#84849c";
		
        $this->SetY(-12);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Pag. '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
		 $this->SetTextColor(114,114, 114);
		 
		    $uno = hexdec(substr($colorcuadros,-6,2));
			$dos = hexdec(substr($colorcuadros,-4,2));
			$tres = hexdec(substr($colorcuadros,-2));
			
			$this->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array($uno, $dos, $tres)));
			$this->RoundedRect(5, 5, 200, 282, 3.50, '1111', 'D');
		 
			$this->Cell(0, 10, 'By www.xnet.mx', 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

 
$tcpdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, false, 'ISO-8859-1', false);  

$tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set title of pdf
$tcpdf->SetTitle("Corte diario");

// set margins
$tcpdf->SetMargins(10, 10, 10, 10);
$tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set header and footer in pdf
$tcpdf->setPrintHeader(false);
$tcpdf->setPrintFooter(true);
$tcpdf->setListIndentWidth(3);

// set auto page breaks
$tcpdf->SetAutoPageBreak(TRUE, 15);

// set image scale factor
$tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

$tcpdf->AddPage();

$template = getPagosTable($corteId, $_SESSION["IDORIGEN"]);
$html = '<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body>
'.$template.'
</body>
</html>';

$tcpdf->writeHTML($html, true, false, false, false, '');


if(isset($_GET['IDCORTE']) && $_GET['IDCORTE'] > 0){
  //$pdf->Output($tipod.".pdf","D");
  ob_end_clean();
  $tcpdf->Output("corte_".intval($_GET['IDCORTE']).'.pdf', 'D');
  exit;
}

$fileatt = $tcpdf->Output('Corte'.'.pdf', 'S');

$selectLogo = sprintf("SELECT LOGO FROM TBL_ORIGEN WHERE IDORIGEN = %s",
					  GetSQLValueString($_SESSION["IDORIGEN"], "int"));
$rsLogo = mysql_query($selectLogo) or die(mysql_error());
$logo = mysql_fetch_assoc($rsLogo)["LOGO"];
$time = date("a");
$greeting = "";

if ($time == 'am') {
	$greeting = "Buenos d&iacute;as";
} else {
	if (date('h') < 18) {
		$greeting = "Buenas tardes";
	} else {
		$greeting = "Buenas noches";
	}
}
mandaCorreoConAdjunto($correos, "Corte De Caja", $greeting.", en el adjunto se encuentra informacion del corte realizado.", '../'.$logo, '', $fileatt, 'Corte');

?>