<?php
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");
require_once("../requires/FuntionsLibrary.php");

$IDPROD = (isset($_POST["PRODUCTO"]) && $_POST["PRODUCTO"] != null && $_POST["PRODUCTO"] != "" && $_POST["PRODUCTO"] > 0) ? $_POST["PRODUCTO"] : "";
$DESDE = (isset($_POST["DESDE"]) && $_POST["DESDE"] != null && $_POST["DESDE"] != "" && $_POST["DESDE"] > 0) ? $_POST["DESDE"] : "";
$HASTA = (isset($_POST["HASTA"]) && $_POST["HASTA"] != null && $_POST["HASTA"] != "" && $_POST["HASTA"] > 0) ? $_POST["HASTA"] : "";

if (isset($_GET['DATA']) && $_GET['DATA'] == 'SIMON') {
    if ($IDPROD != "" && $DESDE != "" && $HASTA != "") {
        $query = sprintf(
            "SELECT
        TD.IDDET,
        TD.IDORDEN,
        TD.PUNIT,
        TH.FECHA_CREO,
        MONTH ( TH.FECHA_CREO ) AS MES,
	    YEAR(TH.FECHA_CREO) AS ANIO,
	    DAY(TH.FECHA_CREO) AS DIA,
		M.MONEDA
        FROM
        TBL_ORDENES_COMPRA_DETAIL TD
        LEFT JOIN TBL_ORDENES_COMPRA_HEADER TH ON TH.IDORDEN = TD.IDORDEN 
		LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA = TH.IDMONEDA 
        WHERE
        TD.IDPROD = %s
        AND TH.AUTORIZADAGERENCIA = 5
        AND TH.IDSTATUS <> 10
        AND TH.IDORIGEN = %s
        AND TH.FECHA_CREO BETWEEN %s
        AND %s
        GROUP BY M.MONEDA, TD.PUNIT",
            GetSQLValueString($IDPROD, "int"),
            GetSQLValueString($_SESSION["IDORIGEN"], "int"),
            GetSQLValueString($DESDE, "text"),
            GetSQLValueString($HASTA, "text")
        );

        $costos = getResultQuery($query);
        $model = array(
            "x" => 0,
            "y" => 0
        );
        $array = array();
        foreach ($costos as $costo) {
            $model["x"] = strtotime($costo["FECHA_CREO"]) * 1000;
            $model["y"] = number_format($costo["PUNIT"], 2);
            $model["MONEDA"] = $costo["MONEDA"];
            array_push($array, $model);
        }
        echo json_encode($array, JSON_NUMERIC_CHECK);
    }
    exit;
}

$query = sprintf("SELECT IDPROD AS ID, DESCRIPCION AS PRODUCTO FROM TBL_PRODUCTOS WHERE ACTIVO=1");
$productos = getResultQuery($query);
?>

<form name="form_filtro" id="form_filtro" onsubmit="return false;">
    <div class="uk-grid">
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>Producto</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <select name="PRODUCTO" id="PRODUCTO">
                        <option value="">Seleccionar...</option>
                        <?php foreach ($productos as $producto) { ?>
                            <?php if ($IDPROD == $producto['ID']) { ?>
                                <option value="<?php echo $producto['ID']; ?>" selected><?php echo $producto["PRODUCTO"]; ?></option>
                            <?php } else { ?>
                                <option value="<?php echo $producto['ID']; ?>"><?php echo $producto['ID'] . " | " . $producto["PRODUCTO"]; ?></option>
                            <?php } ?>
                        <?php } ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>DESDE</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <input type="text" autocomplete="off" class="md-input" name="DESDE" id="DESDE" value="<?php echo ($DESDE != "") ? $DESDE : date("Y-m") . "-01"; ?>" data-uk-datepicker="{format:'YYYY-MM-DD', i18n: { months:['Enero','Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'], weekdays:['Dom','Lun', 'Mar', 'Mie', 'Jue', 'Vie','Sab'] } }">
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>HASTA</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <input type="text" autocomplete="off" class="md-input" name="HASTA" id="HASTA" value="<?php echo ($HASTA != "") ? $HASTA : date("Y-m-d"); ?>" data-uk-datepicker="{format:'YYYY-MM-DD', i18n: { months:['Enero','Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'], weekdays:['Dom','Lun', 'Mar', 'Mie', 'Jue', 'Vie','Sab'] } }">
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px; display: flex;">
            <button style="margin-top: 3px; width: 100%;" class="md-btn md-btn-primary uk-width-medium-1-2" type="button" onclick="filtrar();"><span class="fa fa-search"></span> Filtrar</button>
        </div>
    </div>
</form>
<br>
<br>
<br>
<figure class="highcharts-figure">
    <div id="container"></div>
    <p class="highcharts-description"></p>
</figure>

<script>
    $("#PRODUCTO").selectize({
        create: false,
        plugins: ["restore_on_backspace", "dropdown_after"]
    });
</script>

<script>
    function filtrar() {
        var data = new FormData($("#form_filtro")[0]);
        $.ajax({
            type: "POST",
            url: "grid/grid_report_productos2.php?DATA=SIMON",
            data: data,
            processData: false,
            contentType: false,
            success: function(response) {
                try {
                    grafica.series[0].update({
                        data: JSON.parse(response)
                    });
                    grafica.subtitle.update({
                        text: `${$("#DESDE").val()} / ${$("#HASTA").val()}`
                    });
                    grafica.title.update({
                        text: `${$("#PRODUCTO").text()}`
                    });
                } catch (error) {
                    console.error(error);
                }
            }
        });
    }
</script>

<script>
    // A point click event that uses the Renderer to draw a label next to the point
    // On subsequent clicks, move the existing label instead of creating a new one.
    Highcharts.addEvent(Highcharts.Point, 'click', function() {
        if (this.series.options.className.indexOf('popup-on-click') !== -1) {
            const chart = this.series.chart;
            const date = Highcharts.dateFormat('%A, %b %e, %Y', this.x);
            const text = `<b>${date}</b><br/>${this.y} ${this.series.name}`;

            const anchorX = this.plotX + this.series.xAxis.pos;
            const anchorY = this.plotY + this.series.yAxis.pos;
            const align = anchorX < chart.chartWidth - 200 ? 'left' : 'right';
            const x = align === 'left' ? anchorX + 10 : anchorX - 10;
            const y = anchorY - 30;
            if (!chart.sticky) {
                chart.sticky = chart.renderer
                    .label(text, x, y, 'callout', anchorX, anchorY)
                    .attr({
                        align,
                        fill: 'rgba(0, 0, 0, 0.75)',
                        padding: 10,
                        zIndex: 7 // Above series, below tooltip
                    })
                    .css({
                        color: 'white'
                    })
                    .on('click', function() {
                        chart.sticky = chart.sticky.destroy();
                    })
                    .add();
            } else {
                chart.sticky
                    .attr({
                        align,
                        text
                    })
                    .animate({
                        anchorX,
                        anchorY,
                        x,
                        y
                    }, {
                        duration: 250
                    });
            }
        }
    });


    var grafica = Highcharts.chart('container', {

        chart: {
            scrollablePlotArea: {
                minWidth: 700
            }
        },

        /* data: {
             csvURL: 'https://www.agromalpa.com.mx/system/grid/grid_report_productos2.php?DATA=SIMON',
             beforeParse: function(csv) {
                 return csv.replace(/\n\n/g, '\n');
             }
         },*/

        title: {
            text: 'No se ha seleccionado un producto',
            align: 'left'
        },

        subtitle: {
            text: '- / -',
            align: 'left'
        },

        xAxis: {
            tickInterval: 7 * 24 * 3600 * 1000, // one week
            tickWidth: 0,
            gridLineWidth: 1,
            labels: {
                align: 'left',
                x: 3,
                y: -3,
                formatter: function() {
                    const date = Highcharts.dateFormat('%b %e, %Y', this.value);
                    return '<a href="">' + date + '</a>';
                }
            }
        },

        yAxis: [{ // left y axis
            title: {
                text: null
            },
            labels: {
                align: 'left',
                x: 3,
                y: 16,
                format: '{value:.,0f}'
            },
            showFirstLabel: false
        }, { // right y axis
            linkedTo: 0,
            gridLineWidth: 0,
            opposite: true,
            title: {
                text: null
            },
            labels: {
                align: 'right',
                x: -3,
                y: 16,
                format: '{value:.,0f}'
            },
            showFirstLabel: false
        }],

        legend: {
            align: 'left',
            verticalAlign: 'top',
            borderWidth: 0
        },

        tooltip: {
            shared: true,
            crosshairs: true,
            formatter: function(tooltip) {
                //console.log(this);
                var point = this.points[0].point;
                const date = Highcharts.dateFormat('%A, %b %e, %Y', point.x);
                return /*html*/ `
                <b>${date}</b><br/>
                <span style="color:${point.color}">●</span> ${point.series.name}: <b>${point.y} ${point.MONEDA}</b><br/>
                `;
            }
        },

        plotOptions: {
            series: {
                cursor: 'pointer',
                className: 'popup-on-click',
                marker: {
                    lineWidth: 1
                }
            }
        },

        series: [{
            name: "Costo: ",
            data: []
        }]
    });
</script>