<?php
require_once('sr.php');

if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = ""){
      if (PHP_VERSION < 6) {
        $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
      }

      $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

      switch ($theType) {
        case "text":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
            break;
        case "long":
        case "int":
            $theValue = ($theValue != "") ? intval($theValue) : "NULL";
            break;
        case "double":
            $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
            break;
        case "date":
            $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
            break;
        case "defined":
            $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
            break;
      }
      return $theValue;
    }
}
			
			//Ruta de apis y metodos:
			//https://www.grocerycrud.com/enterprise/api-and-function-list
			include("grocerycrud/libraries/autoload.php");

			use GroceryCrud\Core\GroceryCrud;
			
			$database = include('Connections/promo_groc.php');
			$config = include('grocerycrud/config.php');
			
			$crud = new GroceryCrud($config, $database);
			
			$crud->setTable('TBL_COMENTARIOS_GUIAS');
			$crud->setSubject('Comentarios', 'Comentarios');
			//$crud->columns(['BANCO', 'BENEFICIARIO', 'NUMCUENTA', 'ACTIVO']); //Define que columnas a mostrar en el listado
			
			$crud->unsetDelete(); //Quita funcion eliminar
			$crud->defaultOrdering('TBL_COMENTARIOS_GUIAS.IDGUIA', 'DESC');//Ordena por defecto
			
			
			$crud->setRelation('USUARIO','USUARIOS','{NOMBRE} {APELLIDO}');
			$crud->displayAs('USUARIO','USUARIO');
			
			//$crud->setClone(); //Edito uno y agrego como nuevo
			$crud->setRead();//Permite ver el registro
			//$crud->unsetExport(); //Quita el exportar
			//$crud->unsetPrint(); //Quita imprimir
			$crud->unsetJquery(); //Quita jquery, ya esta cargado en la pagina
			$crud->unsetEdit();
			$crud->unsetAdd();
			
			//$crud->requiredFields(['BANCO']); //Campos requeridos
			//Campos para quitar al insertar
			//$crud->unsetAddFields(['USUARIOCREO', 'USUARIOMOD', 'CREADO', 'MODIFICADO']); 
			//Campos para quitar al EDITAR
		//	$crud->unsetEditFields(['USUARIOCREO', 'USUARIOMOD', 'CREADO', 'MODIFICADO']); 
			
			//Manda usuario creo el dato que quiero, al agregar
			/*$crud->callbackAddField('USUARIOCREO', function ($value, $primary_key) {
            	return '<input type="hidden" value="'.$_SESSION["MM_Username"].'" name="USUARIOCREO">'.$_SESSION["MM_Username"];
       		});	
			
			//Manda usuario creo el dato que quiero, al agregar
			$crud->callbackAddField('USUARIOMOD', function ($value, $primary_key) {
            	return '<input type="hidden" value="'.$_SESSION["MM_Username"].'" name="USUARIOMOD">'.$_SESSION["MM_Username"];
       		});	
			
			//Manda usuariomod el dato que quiero, al editar
			$crud->callbackEditField('USUARIOCREO', function ($value, $primary_key) {
            	return '<input type="hidden" value="'.$value.'" name="USUARIOCREO">'.$value;
       		});
			
			//Manda usuariomod el dato que quiero, al editar
			$crud->callbackEditField('USUARIOMOD', function ($value, $primary_key) {
            	return '<input type="hidden" value="'.$_SESSION["MM_Username"].'" name="USUARIOMOD">'.$_SESSION["MM_Username"];
       		});*/
			
			//Antes de insertar, pongo la fecha de creacion
			/*$crud->callbackBeforeInsert(function ($stateParameters) {
				$stateParameters->data['CREADO'] = date("Y-m-d H:i:s");
				$stateParameters->data['USUARIOCREO'] = $_SESSION["MM_Username"];
				return $stateParameters;
			});
			//Antes de actualizar, pongo la fecha de modificacion
			$crud->callbackBeforeUpdate(function ($stateParameters) {
				$stateParameters->data['USUARIOMOD'] = $_SESSION["MM_Username"];
				$stateParameters->data['MODIFICADO'] = date("Y-m-d H:i:s");
			
				return $stateParameters;
			});
			*/
			//$crud->fieldType('ACTIVO', 'checkbox_boolean'); //Cambia a checkbox
			
			$output = $crud->render();
			
			if ($output->isJSONResponse) {
				header('Content-Type: application/json; charset=utf-8');
				echo $output->output;
				exit;
			}
			
			$css_files = $output->css_files;
			$js_files = $output->js_files;
			$output = $output->output;
			
			include('grocerycrud/view.php');
						
			
			?>
 




