<?php
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");

if (!function_exists("ejecutarQuery")) {
    function ejecutarQuery($query)
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet);
        return $res;
    }
}

if (!function_exists("getResultQuery")) {
    function getResultQuery($query)
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet) or die(mysql_error());
        $result = array();
        while ($r = mysql_fetch_assoc($res)) {
            array_push($result, $r);
        }
        return $result;
    }
}

if (!function_exists("setStartRollBack")) {
    function setStartRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("START TRANSACTION;", $xnet) or die(mysql_error());
        return $res;
    }
}

if (!function_exists("doRollBack")) {
    function doRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("ROLLBACK;", $xnet) or die(mysql_error());
        return $res;
    }
}

if (!function_exists("doCommitRollBack")) {
    function doCommitRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("COMMIT;", $xnet) or die(mysql_error());
        return $res;
    }
}
if (isset($_GET['VERIFICAR_CAMPOS']) && $_GET['VERIFICAR_CAMPOS'] == 'SIMON') {
    //checo que fecha_entrega, direccion, oc, y condiciones de pago no esten vacios en el cot header
    $campos_ = getResultQuery(sprintf(
        "SELECT FECHA_ENTREGA, CASE WHEN OTRA_DIRECCION = 0 THEN IDDIRECCION ELSE DIRECCION END AS IDDIRECCION, DIAS_CREDITO, OC FROM TBL_COT_HEADER WHERE IDCOT = %s",
        GetSQLValueString($_POST["IDCOT"], "int")
    ))[0];

    $errores = "";
    if ($campos_["FECHA_ENTREGA"] == "") {
        $errores .= "El campo <b>FECHA DE ENTREGA</b> es requerido<br>";
    }
    if ($campos_["IDDIRECCION"] == "") {
        $errores .= "El campo <b>DIRECCION</b> es requerido<br>";
    }
    if ($campos_["DIAS_CREDITO"] == "") {
        $errores .= "El campo <b>CONDICIONES DE PAGO</b> es requerido<br>";
    }
    if ($campos_["OC"] == "") {
        $errores .= "El campo <b>OC</b> es requerido<br>";
    }

    if ($errores != "") {
        echo json_encode(array("success" => 0, "message" => "<br>".$errores . "<br><br>Asegurece de llenar estos campos y guardar los cambios antes de procesar."));
    } else {
        echo json_encode(array("success" => 1, "message" => "Todo bien"));
    }
    exit;
}

//WEB-SERVICE
if (isset($_GET["GET"]) && $_GET["GET"] == "PRODUCTO") {
    $query = sprintf(
        "SELECT
        P.IDPROD,
        P.IDFAMILIA,
        P.CODIGO,
        P.DESCRIPCION,
        COALESCE ( TPC.PRECIO_VENTA, COALESCE ( P.PRECIO, 0 ) ) AS PRECIO,
        COALESCE(TPC.CANTIDAD, 1) AS CANTIDAD,
        P.COSTO,
        P.MONEDAPRECIO,
        P.FECHA_CREACION,
        P.USUARIOCREO,
        P.FECHA_MODIFICACION,
        P.USUARIOMOD,
        P.ACTIVO,
        COALESCE (TPC.UNIDAD, P.UNIDAD) AS UNIDAD
        FROM
        TBL_PRODUCTOS P
        LEFT JOIN TBL_PRODUCTOS_CLIENTE TPC ON TPC.IDPROD = P.IDPROD 
        AND TPC.IDCTE = %s AND TPC.MONEDA=%s
        WHERE
        P.IDPROD = %s",
        GetSQLValueString($_POST["IDCTE"], "int"),
        GetSQLValueString($_POST["MONEDA"], "int"),
        GetSQLValueString($_POST["IDPROD"], "int")
    );
    $res = ejecutarQuery($query);
    $r = mysql_fetch_assoc($res);
    echo json_encode($r);
    exit;
}

if (isset($_GET["GET"]) && $_GET["GET"] == "PARTIDA") {
    $query = sprintf(
        "SELECT TCD.*, P.DESCRIPCION AS PRODUCTO, COALESCE(TCD.MONEDA, CH.IDMONEDA) AS LAIDMONEDA, COALESCE(TCD.TCAMBIO, V.DOLARDIARIOOFICIAL) AS ELTCAMBIO FROM TBL_COT_DETAIL TCD 
		LEFT JOIN TBL_PRODUCTOS P ON P.IDPROD=TCD.IDPROD 
		LEFT JOIN TBL_COT_HEADER CH ON CH.IDCOT = TCD.IDCOT
		LEFT JOIN TBL_VALCOTS V ON V.IDVAL = 1
		WHERE IDDET=%s",
        GetSQLValueString($_POST["ID"], "int")
    );
    $res = ejecutarQuery($query);
    $r = mysql_fetch_assoc($res);
    echo json_encode($r);
    exit;
}

if (isset($_GET["PROCESAR"]) && $_GET["PROCESAR"] == "SIMON") {
    $IDDETS_TEXTO =  $_POST["PARTIDAS"];
    $IDDETS = explode(",", $_POST["PARTIDAS"]);
    $IDCOT = $_POST["IDCOT"];
    $ALMACEN = $_POST["ALMACEN"];
    $COMENTARIO = isset($_POST["COMENTARIO"]) ? $_POST["COMENTARIO"] : "";

    //PROCESO PARA PROD HEADER
    $query_cot = sprintf(
        "SELECT
        COT.*,
        M.MONEDA 
        FROM
        TBL_COT_HEADER COT
        LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA = COT.IDMONEDA 
        WHERE
        COT.IDCOT =%s",
        $IDCOT
    );

    $cotizacion = getResultQuery($query_cot)[0];

    $query_header = sprintf(
        "INSERT INTO TBL_ORDENES_PROD_HEADER (FECHA,ORIGEN,IDALMACEN,COMENTARIO,IDOPERADOR,IDCTE,COT,FECHA_CREACION,USUARIOCREO) VALUES (%s,%s,%s,%s,%s,%s,%s,NOW(),%s)",
        GetSQLValueString($cotizacion["FECHA_CREACION"], "text"),
        GetSQLValueString($cotizacion["IDORIGEN"], "int"),
        GetSQLValueString($ALMACEN, "int"),
        GetSQLValueString($COMENTARIO, "text"),
        GetSQLValueString($cotizacion["IDVENDEDOR"], "int"),
        GetSQLValueString($cotizacion["IDCTE"], "int"),
        GetSQLValueString($IDCOT, "int"),
        GetSQLValueString($_SESSION["IDOPERADOR"], "int")
    );

    setStartRollBack();
    //echo $query_header;
    $h = ejecutarQuery($query_header);

    $query_op_max = sprintf(
        "SELECT MAX(IDORDEN) AS ID FROM TBL_ORDENES_PROD_HEADER WHERE USUARIOCREO = %s",
        GetSQLValueString($_SESSION["IDOPERADOR"], "int")
    );

    $ID_PROD_HEADER = getResultQuery($query_op_max)[0]["ID"];

    //PROCESO PARA PROD DETAIL
    $query_partida = sprintf(
        "SELECT CD.*,
							 COALESCE(M.MONEDA, M2.IDMONEDA) AS LAMONEDA
							 FROM TBL_COT_DETAIL CD
							 LEFT JOIN TBL_COT_HEADER CH ON CH.IDCOT = CD.IDCOT
							 LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA = CD.MONEDA
							 LEFT JOIN TBL_MONEDAS M2 ON M2.IDMONEDA = CH.IDMONEDA
							 WHERE CD.IDDET IN (%s)",

        GetSQLValueString($IDDETS_TEXTO, "texto")
    );
    $partidas = getResultQuery($query_partida);

    $query = "SELECT DOLARDIARIOOFICIAL FROM TBL_VALCOTS";
    $DOLAR = getResultQuery($query)[0]["DOLARDIARIOOFICIAL"];

    $inserts = "";
    foreach ($partidas as $partida) {
        $query_detail = sprintf(
            "INSERT INTO TBL_ORDENES_PROD_DETAIL (UNID, CANT, DESCRIPCION, COMENTARIO, IDORDEN, PUNIT, MONEDA, IDPROD,DOLAR, TIEMPO_ENTREGA, PARTIDACOT, FECHA_CREACION, USUARIOCREO, IDSTATUS, FECHAPROD) VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,now(),%s,1,%s);",
            GetSQLValueString($partida["UNIDAD"], "text"),
            GetSQLValueString($partida["CANTIDAD"], "double"),
            GetSQLValueString($partida["DESCRIPCION"], "text"),
            GetSQLValueString($cotizacion["COMENTARIO"], "text"),
            GetSQLValueString($ID_PROD_HEADER, "int"),
            GetSQLValueString($partida["PRECIO"], "double"),
            GetSQLValueString($partida["LAMONEDA"], "text"),
            GetSQLValueString($partida["IDPROD"], "int"),
            GetSQLValueString($DOLAR, "double"),
            GetSQLValueString($partida["TIEMPO_ENTREGA"], "text"),
            GetSQLValueString($partida["IDDET"], "int"),
            GetSQLValueString($_SESSION["IDOPERADOR"], "int"),
            GetSQLValueString($cotizacion["FECHA_ENTREGA"], "text")
        );
        $d = ejecutarQuery($query_detail);
        //$inserts .= $query_detail;
    }

    //echo $inserts;

    $query = sprintf("UPDATE TBL_COT_HEADER SET PROCESADA=1, ETAPA=4 WHERE IDCOT=%s", $IDCOT);
    $u = ejecutarQuery($query);

    $query = sprintf(
        "INSERT INTO TBL_COMENTARIOS_COTIZACIONES (IDCOT, IDETAPA, IDUSUARIO, COMENTARIO) VALUES (%s,4,%s,'Cotización puesta en producción')",
        GetSQLValueString($IDCOT, "int"),
        GetSQLValueString($_SESSION["IDOPERADOR"], "int")
    );

    $c = ejecutarQuery($query);

    $r = ejecutarQuery(sprintf("UPDATE TBL_COT_DETAIL SET PROCESADA=1 WHERE IDDET IN (%s)", $IDDETS_TEXTO));

    if ($u && $h && $c) {
        // $success = 1;
        //  $message = "Cotizacion mandada a produccion";
        //el success y message se encuentran en el etc/pdfOrdenPadreV2.php
        //Manda aviso por correo
        mysql_select_db($database_xnet, $xnet);
        $query_saca_op = sprintf(
            "SELECT
									PH.IDORDEN,
									CL.NOMBRE AS CLIENTE,
									O.NOMBRE AS SUCURSAL,
									O.EMAILS_OPS,
									U.EMAIL,
									A.UBICACION AS ALMACEN,
									PH.COMENTARIO,
									PH.COT
								FROM
									 TBL_ORDENES_PROD_HEADER PH 
									LEFT JOIN TBL_CLIENTES CL ON CL.IDCTE = PH.IDCTE
									LEFT JOIN TBL_ORIGEN O ON O.IDORIGEN = PH.ORIGEN
									LEFT JOIN USUARIOS U ON U.ID = PH.IDOPERADOR
									LEFT JOIN TBL_ALMACEN A ON A.IDALMACEN = PH.IDALMACEN
								WHERE
									PH.IDORDEN = %s",
            GetSQLValueString($ID_PROD_HEADER, "int")
        );
        $saca_op = mysql_query($query_saca_op, $xnet) or die(mysql_error());
        $row_saca_op = mysql_fetch_assoc($saca_op);


        $emails = $row_saca_op["EMAILS_OPS"]; //Responsables de la sucursal
        $emails .= "," . $row_saca_op["EMAIL"]; //Al vendedor

        //echo $emails; exit;

        if ($emails != "") {

            $_GET['IDORDEN'] = $ID_PROD_HEADER;
            $_GET["ENVIACORREO"] = "simon";
            $_GET["ASUNTO"] = "Pedido #" . $ID_PROD_HEADER . " procesado";
            $_GET["CORREO"] = $emails;
            $_GET["MENSAJE"] = "Buen día, se adjunta el pedido <strong>#" . $ID_PROD_HEADER . "</strong> procesado de la cotizacion <strong>#" . $row_saca_op["COT"] . "</strong>: <br>-Cliente <b>" . $row_saca_op["CLIENTE"] . "</b><br>-Sucursal: <b>" . $row_saca_op["SUCURSAL"] . "</b><br>-Almacen: <b>" . $row_saca_op["ALMACEN"] . "</b><br>-Comentario: " . $row_saca_op["COMENTARIO"];

            require_once("../etc/pdfOrdenPadreV2.php");
            //En pdfOrdenPadreV2.php nos dira si pudo enviar o no, si no pudo enviar mandara aviso y hara el rollback
        } else {
            //Si no encontro correos, igual que avise que se proceso
            $success = 1;
            $message = "Cotizacion enviada a produccion!";
            doCommitRollBack();
        } //fin else emails


    } else {
        $success = 0;
        $letra = "";
        $letra .= ($u) ? "" : "u";
        $letra .= ($d) ? "" : "d";
        $letra .= ($h) ? "" : "h";
        $letra .= ($c) ? "" : "c";
        $message = "Oops!.. Algo salio mal - " . $letra;
        doRollBack();
    }

    echo json_encode(array("success" => $success, "message" => $message));
    exit;
}

if (isset($_GET["PARTIDA"]) && $_GET["PARTIDA"] == "SIMON") {

    $query_montos = sprintf(
        "SELECT MONTO_SUBTOTAL, MONTO_IVA, MONTO_RETENCION, MONTO_TOTAL FROM TBL_COT_HEADER WHERE IDCOT=%s",
        GetSQLValueString($_POST["IDCOT"], "int")
    );

    if ($_POST["ACCION"] == "NUEVO") {
        $query = sprintf(
            "INSERT INTO TBL_COT_DETAIL (IDCOT, IDPROD, PRECIO, UNIDAD, CANTIDAD, DESCRIPCION, TIEMPO_ENTREGA, USUARIOCREO, IVA, RETENCION, MONEDA, TCAMBIO) VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s, %s, %s)",
            GetSQLValueString($_POST["IDCOT"], "int"),
            GetSQLValueString($_POST["PRODUCTO"], "int"),
            GetSQLValueString($_POST["PRECIO"], "double"),
            GetSQLValueString($_POST["UNIDAD"], "text"),
            GetSQLValueString($_POST["CANTIDAD"], "double"),
            GetSQLValueString($_POST["DESCRIPCION"], "text"),
            GetSQLValueString($_POST["TIEMPO"], "text"),
            GetSQLValueString($_SESSION["IDOPERADOR"], "int"),
            GetSQLValueString($_POST["IVA"], "double"),
            GetSQLValueString($_POST["RETENCION"], "double"),
            GetSQLValueString($_POST["MONEDA_PARTIDA"], "int"),
            GetSQLValueString($_POST["TCAMBIO"], "double")
        );
        ejecutarQuery($query);
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "message" => "Partida creada",
            "data" => $montos
        ));
    } else {
        $query = sprintf(
            "UPDATE TBL_COT_DETAIL SET IDPROD=%s, PRECIO=%s, UNIDAD=%s, CANTIDAD=%s, DESCRIPCION=%s, TIEMPO_ENTREGA=%s, USUARIOMOD=%s, IVA=%s, RETENCION=%s, MONEDA=%s, TCAMBIO=%s WHERE IDDET=%s",
            GetSQLValueString($_POST["PRODUCTO"], "int"),
            GetSQLValueString($_POST["PRECIO"], "double"),
            GetSQLValueString($_POST["UNIDAD"], "text"),
            GetSQLValueString($_POST["CANTIDAD"], "double"),
            GetSQLValueString($_POST["DESCRIPCION"], "text"),
            GetSQLValueString($_POST["TIEMPO"], "text"),
            GetSQLValueString($_SESSION["IDOPERADOR"], "int"),
            GetSQLValueString($_POST["IVA"], "double"),
            GetSQLValueString($_POST["RETENCION"], "double"),
            GetSQLValueString($_POST["MONEDA_PARTIDA"], "int"),
            GetSQLValueString($_POST["TCAMBIO"], "double"),
            GetSQLValueString($_POST["IDDET"], "int")
        );
        ejecutarQuery($query);
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "message" => "Partida guardada",
            "data" => $montos
        ));
    }
    exit;
}

if (isset($_GET["INACTIVAR"]) && $_GET["INACTIVAR"] == "SIMON") {

    $query_montos = sprintf(
        "SELECT
        COT.MONTO_SUBTOTAL,
        COT.MONTO_IVA,
        COT.MONTO_RETENCION,
        COT.MONTO_TOTAL 
        FROM
        TBL_COT_DETAIL CD
        LEFT JOIN TBL_COT_HEADER COT ON COT.IDCOT = CD.IDCOT
        WHERE IDDET = %s",
        GetSQLValueString($_POST["IDDET"], "int")
    );

    $query = sprintf(
        "UPDATE TBL_COT_DETAIL SET ACTIVO=%s WHERE IDDET=%s",
        GetSQLValueString($_POST["VALUE"], "int"),
        GetSQLValueString($_POST["IDDET"], "int")
    );
    ejecutarQuery($query);
    if ($_POST["VALUE"] == 0) {
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "message" => "Partida desactivada",
            "data" => $montos
        ));
    } else {
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "message" => "Partida activada",
            "data" => $montos
        ));
    }
    exit;
}

if (isset($_GET["BORRAR"]) && $_GET["BORRAR"] == "SIMON") {

    $query_montos = sprintf(
        "SELECT
        COT.IDCOT
        FROM
        TBL_COT_DETAIL CD
        LEFT JOIN TBL_COT_HEADER COT ON COT.IDCOT = CD.IDCOT
        WHERE CD.IDDET = %s",
        GetSQLValueString($_POST["IDDET"], "int")
    );

    $IDCOT = getResultQuery($query_montos)[0]["IDCOT"];


    $query_montos = sprintf(
        "SELECT
        COT.MONTO_SUBTOTAL,
        COT.MONTO_IVA,
        COT.MONTO_RETENCION,
        COT.MONTO_TOTAL 
        FROM
        TBL_COT_HEADER COT
        WHERE COT.IDCOT = %s",
        GetSQLValueString($IDCOT, "int")
    );

    $query = sprintf(
        "DELETE FROM TBL_COT_DETAIL WHERE IDDET=%s",
        GetSQLValueString($_POST["IDDET"], "int")
    );
    ejecutarQuery($query);
    $montos = getResultQuery($query_montos)[0];
    echo json_encode(array(
        "message" => "Partida eliminada",
        "data" => $montos
    ));
    exit;
}

if (isset($_GET["TRAER"]) && $_GET["TRAER"] == "SIMON") {
    $query = sprintf(
        "SELECT * FROM TBL_PRODUCTOS_CLIENTE WHERE IDCTE=%s",
        GetSQLValueString($_POST["IDCTE"], "int")
    );

    $productos = getResultQuery($query);

    if (count($productos) > 0) {
        foreach ($productos as $producto) {
            $query = sprintf(
                "INSERT INTO TBL_COT_DETAIL (IDCOT, IDPROD, PRECIO, UNIDAD, CANTIDAD, DESCRIPCION, TIEMPO_ENTREGA, USUARIOCREO, IVA, RETENCION, MONEDA) VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)",
                GetSQLValueString($_POST["IDCOT"], "int"),
                GetSQLValueString($producto["IDPROD"], "int"),
                GetSQLValueString($producto["PRECIO_VENTA"], "double"),
                GetSQLValueString($producto["UNIDAD"], "text"),
                GetSQLValueString($producto["CANTIDAD"], "double"),
                GetSQLValueString("", "text"),
                GetSQLValueString("", "text"),
                GetSQLValueString($_SESSION["IDOPERADOR"], "int"),
                GetSQLValueString($_POST["IVA"], "double"),
                GetSQLValueString($_POST["RETENCION"], "double"),
                GetSQLValueString($producto["MONEDA"], "int")
            );
            ejecutarQuery($query);
        }
        $query_montos = sprintf(
            "SELECT MONTO_SUBTOTAL, MONTO_IVA, MONTO_RETENCION, MONTO_TOTAL FROM TBL_COT_HEADER WHERE IDCOT=%s",
            GetSQLValueString($_POST["IDCOT"], "int")
        );
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "success" => 1,
            "message" => "Partidas creadas",
            "data" => $montos
        ));
    } else {
        //el cliente no tiene productos
        $query_montos = sprintf(
            "SELECT MONTO_SUBTOTAL, MONTO_IVA, MONTO_RETENCION, MONTO_TOTAL FROM TBL_COT_HEADER WHERE IDCOT=%s",
            GetSQLValueString($_POST["IDCOT"], "int")
        );
        $montos = getResultQuery($query_montos)[0];
        echo json_encode(array(
            "success" => 0,
            "message" => "El cliente no tiene productos con precios especiales.",
            "data" => $montos
        ));
    }

    exit;
}
?>

<?php $idcot = $_GET["IDCOT"]; ?>

<?php
$query = sprintf(
    "SELECT O.IVA, O.RETENCION, COT.IDCTE, COT.IDMONEDA AS MONEDA, V.DOLARDIARIOOFICIAL AS TCAMBIO FROM TBL_COT_HEADER COT 
	LEFT JOIN TBL_ORIGEN O ON O.IDORIGEN=COT.IDORIGEN 
	LEFT JOIN TBL_VALCOTS V ON V.IDVAL = 1
	WHERE COT.IDCOT=%s",
    GetSQLValueString($idcot, "int")
);

$data = getResultQuery($query)[0];
$iva = $data["IVA"];
$reten = $data["RETENCION"];
$tcambio = $data["TCAMBIO"];


$IDCTE = $data["IDCTE"];
$MONEDA = $data["MONEDA"];
?>

<!--PARTIDAS-->
<?php $editar = true; ?>
<?php $activo = false; ?>
<?php $borrar = true; ?>
<?php $seleccion = true; ?>
<?php $cant_editar = array(); ?>
<?php $cant_activar = array(); ?>
<?php $cant_borrar = array(); ?>
<?php $cant_seleccionar = array(); ?>


<?php
$query = sprintf(
    "SELECT TCD.*, P.DESCRIPCION AS PRODUCTO, COALESCE(M.MONEDA, M2.MONEDA) AS MONEDA FROM TBL_COT_DETAIL TCD 
	LEFT JOIN TBL_PRODUCTOS P ON P.IDPROD=TCD.IDPROD 
	LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA = TCD.MONEDA
	LEFT JOIN TBL_COT_HEADER CH ON CH.IDCOT = TCD.IDCOT
	LEFT JOIN TBL_MONEDAS M2 ON M2.IDMONEDA = CH.IDMONEDA
	WHERE TCD.IDCOT=%s",
    $idcot
);
$partidas = getResultQuery($query);
?>

<div style="margin-top: 50px;">
    <div class="uk-grid">
        <div class="uk-width-1-3">
            <b style="font-size:16px;">Mostrando <?php echo count($partidas); ?> &nbsp;Partidas. </b>
            <br>
            <p style="font-size: 13px;"><b>Nota: </b>Las partidas en color verde ya fuerón procesadas.</p>
        </div>
        <div class="uk-width-2-3" align="right">
            <button class="md-btn md-btn-primary uk-width-medium-1-3 <?php if ($bloquear) { ?> disabled <?php } ?>" type="button" onclick="llenar(<?php echo $IDCTE; ?>)">Traer productos del cliente</button>
        </div>
    </div>
</div>
<form id="form_seleccion">
    <div id="PARTIDAS">
        <table class="uk-table">
            <thead>
                <tr>
                    <th style="width: 155px;">ACCIONES</th>
                    <th>ID</th>
                    <th>PRODUCTO</th>
                    <th>PRECIO</th>
                    <th>MONEDA</th>
                    <th>T. CAMBIO</th>
                    <th>UNIDAD</th>
                    <th>CANTIDAD</th>
                    <th>DESCRIPCION</th>
                    <th>TIEMPO DE ENTREGA</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($partidas) > 0) { ?>
                    <?php foreach ($partidas as $partida) { ?>
                        <tr style='background-color: <?php echo ($partida["PROCESADA"] == 1) ? "#97cf8a" : "white"; ?>;'>
                            <td>
                                <?php if ($seleccion) { ?>
                                    <?php if (!in_array($partida["IDDET"], $cant_seleccionar)) { ?>
                                        <?php if ($partida["PROCESADA"] == 0) { ?>
                                            <input type="checkbox" name="SELECCION" id="SELECCION_<?php echo $partida["IDDET"]; ?>" value="<?php echo $partida["IDDET"]; ?>" style="margin-right: 20px;" <?php if ($bloquear) { ?> disabled <?php } ?>>
                                        <?php } else { ?>
                                            <input type="checkbox" name="SELECCION" id="SELECCION_<?php echo $partida["IDDET"]; ?>" style="margin-right: 20px;" disabled>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                                <?php if ($editar) { ?>
                                    <?php if ($partida["PROCESADA"] != 1) { ?>
                                        <?php if (!in_array($partida["IDDET"], $cant_editar)) { ?>
                                            <a onClick="open_modal_crear('EDITAR', '<?php echo $partida['IDDET'] ?>')" class="md-btn md-btn-primary md-btn-mini btnEdita <?php if ($bloquear) { ?> disabled <?php } ?>" href="javascript: void(0)">
                                                <span class="fas fa-pen"></span>
                                            </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                                <?php if ($activo) { ?>
                                    <?php if (!in_array($partida["IDDET"], $cant_activar)) { ?>
                                        <?php if ($partida["ACTIVO"] == 1) { ?>
                                            <a data-uk-tooltip title="Desactivar" onClick='inactivarPartida(<?php echo $partida['IDDET'] ?>, 0)' class="md-btn md-btn-danger md-btn-mini btnActiva <?php if ($bloquear) { ?> disabled <?php } ?>" href="javascript: void(0)"><span class="fas fa-trash"></span> </a>
                                        <?php } else { ?>
                                            <a data-uk-tooltip title="Activar" onClick='inactivarPartida(<?php echo $partida['IDDET'] ?>, 1)' class="md-btn md-btn-success md-btn-mini <?php if ($bloquear) { ?> disabled <?php } ?>" href="javascript: void(0)"><span class="fas fa-check"></span> </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                                <?php if ($borrar) { ?>
                                    <?php if ($partida["PROCESADA"] != 1) { ?>
                                        <?php if (!in_array($partida["IDDET"], $cant_borrar)) { ?>
                                            <a data-uk-tooltip title="Eliminar" onClick='borrarPartida(<?php echo $partida['IDDET'] ?>)' class="md-btn md-btn-danger md-btn-mini btnActiva <?php if ($bloquear) { ?> disabled <?php } ?>" href="javascript: void(0)"><span class="fas fa-trash"></span> </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            </td>
                            <td><?php echo $partida["IDDET"]; ?></td>
                            <td><?php echo $partida["PRODUCTO"]; ?></td>
                            <td><?php echo $partida["PRECIO"]; ?></td>
                            <td><?php echo $partida["MONEDA"]; ?></td>
                            <td><?php echo $partida["TCAMBIO"]; ?></td>
                            <td><?php echo $partida["UNIDAD"]; ?></td>
                            <td><?php echo $partida["CANTIDAD"]; ?></td>
                            <td><?php echo $partida["DESCRIPCION"]; ?></td>
                            <td><?php echo $partida["TIEMPO_ENTREGA"]; ?></td>
                        </tr>
                    <?php } ?>
                <?php } else { ?>
                    <tr>
                        <td colspan="8" style="text-align: center;">No hay partidas</td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</form>

<?php
$query = sprintf("SELECT IDPROD, DESCRIPCION FROM TBL_PRODUCTOS WHERE ACTIVO=1");
$productos = getResultQuery($query);
?>

<?php
$query = sprintf("SELECT * FROM TBL_UNIDADES");
$unidades = getResultQuery($query);

$queryMon = sprintf("SELECT * FROM TBL_MONEDAS WHERE ACTIVO=1");
$monedas = getResultQuery($queryMon);
?>

<!--MODAL PARTIDA-->
<?php $modal_id = "createPartida"; ?>
<?php $titulo = "Agregar Partida"; ?>
<div class="uk-modal" id="<?php echo $modal_id; ?>">
    <div class="uk-modal-dialog">
        <button class="uk-modal-close uk-close" type="button"></button>
        <form id="form_<?php echo $modal_id; ?>">
            <div class="uk-modal-header">
                <h3 class="uk-modal-title" id="titulo_<?php echo $modal_id; ?>"><?php echo $titulo; ?></h3>
            </div>
            <div class="uk-grid">
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Producto</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <select name="PRODUCTO" id="PRODUCTO" isrequired="1">
                                <option value="" selected>Seleccionar...</option>
                                <?php foreach ($productos as $producto) { ?>
                                    <option value="<?php echo $producto['IDPROD']; ?>"><?php echo $producto['IDPROD'] . " | " . $producto["DESCRIPCION"]; ?></option>
                                <?php } ?>
                            </select>
                            <h2 class="required" id="required_PRODUCTO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Moneda</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <select onchange="convierteMonto(this.value)" name="MONEDA_PARTIDA" id="MONEDA_PARTIDA" isrequired="1">
                                <option value="" selected>Seleccionar...</option>
                                <?php foreach ($monedas as $moneda) { ?>
                                    <option value="<?php echo $moneda['IDMONEDA']; ?>"><?php echo $moneda["MONEDA"]; ?></option>
                                <?php } ?>
                            </select>
                            <h2 class="required" id="required_MONEDA_PARTIDA" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Tipo Cambio</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="TCAMBIO" id="TCAMBIO" class="md-input" isrequired="1">
                            <h2 class="required" id="required_TCAMBIO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Unidad</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <select name="UNIDAD" id="UNIDAD" isrequired="1">
                                <option value="" selected>Seleccionar...</option>
                                <?php foreach ($unidades as $unidad) { ?>
                                    <option value="<?php echo $unidad['ABREV']; ?>"><?php echo $unidad["UNIDAD"]; ?></option>
                                <?php } ?>
                            </select>
                            <h2 class="required" id="required_UNIDAD" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Precio</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="PRECIO" id="PRECIO" class="md-input" isrequired="1">
                            <h2 class="required" id="required_PRECIO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Cantidad</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="CANTIDAD" id="CANTIDAD" class="md-input" isrequired="1">
                            <h2 class="required" id="required_CANTIDAD" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Tiempo de entrega</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="TIEMPO" id="TIEMPO" class="md-input" isrequired="0">
                            <h2 class="required" id="required_TIEMPO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Descripcion</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <textarea name="DESCRIPCION" id="DESCRIPCION" cols="30" rows="6" class="md-input" isrequired="1"></textarea>
                            <h2 class="required" id="required_TIEMPO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>IVA</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="IVA" id="IVA" class="md-input" isrequired="1">
                            <h2 class="required" id="required_IVA" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Retención</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <input type="text" name="RETENCION" id="RETENCION" class="md-input" isrequired="1">
                            <h2 class="required" id="required_RETENCION" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="ACCION" id="ACCION" value="NUEVO" isrequired="0">
            <input type="hidden" name="IDDET" id="IDDET" value="0" isrequired="0">
            <input type="hidden" name="IDCOT" id="IDCOT" value="<?php echo $idcot; ?>" isrequired="0">
            <div class="uk-modal-footer">
                <button type="button" class="uk-float-right md-btn md-btn-flat md-btn-flat-primary" onclick="guardar()">Guardar</button>
            </div>
        </form>
    </div>
</div>

<!--MODAL PROCESAR-->
<div class="uk-modal" id="procesar">
    <div class="uk-modal-dialog">
        <button class="uk-modal-close uk-close" type="button"></button>
        <form id="form_procesar">
            <div class="uk-modal-header">
                <h3 class="uk-modal-title" id="titulo_procesar">Procesar partidas</h3>
            </div>
            <div class="uk-grid">
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Almacen</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <?php $OTRA = (isset($cotizacion)) ? $cotizacion["IDORIGEN"] : $_GET["IDORIGEN"]; ?>
                            <?php $almacenes = getResultQuery("SELECT IDALMACEN, UBICACION FROM TBL_ALMACEN WHERE SUCURSAL=" . $OTRA); ?>
                            <select name="ALMACEN" id="ALMACEN" isrequired="1">
                                <option value="0" selected>Seleccionar...</option>
                                <?php foreach ($almacenes as $almacen) { ?>
                                    <option value="<?php echo $almacen['IDALMACEN']; ?>"><?php echo $almacen["UBICACION"]; ?></option>
                                <?php } ?>
                            </select>
                            <h2 class="required" id="required_ALMACEN" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
                <div class="uk-width-medium-1-1" style="margin-bottom: 15px;">
                    <div class="uk-grid">
                        <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                            <label><b>Comentario</b></label>
                        </div>
                        <div class="uk-width-medium-3-4">
                            <textarea isrequired="0" class="md-input selecize_init" name="COMENTARIO" id="COMENTARIO" cols="75" rows="7" style="overflow-x: hidden; overflow-wrap: break-word; height: 193px;"></textarea>
                            <h2 class="required" id="required_COMENTARIO" style="font-size: 10px; margin: 0; color: red;">Campo requerido</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="uk-modal-footer">
                <button type="button" class="uk-float-right md-btn md-btn-flat md-btn-flat-primary" onclick="guardar_procesar()">Procesar</button>
            </div>
        </form>
    </div>
</div>



<script>
    var modal_crear_partida = UIkit.modal("#<?php echo $modal_id; ?>");
    var form = $("#form_<?php echo $modal_id; ?>")[0];
    var formID = "form_<?php echo $modal_id; ?>";
    var acuarlizar = true;


    var modal_procesar = UIkit.modal("#procesar");
    var form_procesar = $("#form_procesar")[0];


    $(".required").css("display", "none");

    $("#PRODUCTO").selectize({
        create: false,
        plugins: ["restore_on_backspace", "dropdown_after"],
        onChange: function(value) {
            if (value != null && value != "" && value != 0 && acuarlizar) {
                var form_get = new FormData();
                form_get.append("IDPROD", value);
                form_get.append("IDCTE", "<?php echo $IDCTE; ?>");
                form_get.append("MONEDA", $("#MONEDA_PARTIDA").val());
                $.ajax({
                    type: "POST",
                    url: "requires/cot_partidas.php?GET=PRODUCTO",
                    data: form_get,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        try {
                            var data = JSON.parse(response);
                            $("#PRECIO").val(data.PRECIO);
                            $("#DESCRIPCION").val(data.DESCRIPCION);
                            $("#CANTIDAD").val(data.CANTIDAD);
                            setOption("UNIDAD", data.UNIDAD);
                        } catch (error) {
                            console.error(error);
                        }
                    }
                });
            } else {
                if (value == 0) {
                    reiniciar_formulario(formID);
                }
            }
        }
    });

    $("#ALMACEN").selectize({
        create: false,
        plugins: ["restore_on_backspace"]
    });

    $("#UNIDAD").selectize({
        create: false,
        plugins: ["restore_on_backspace", "dropdown_after"]
    });

    $("#MONEDA_PARTIDA").selectize({
        create: false,
        plugins: ["restore_on_backspace", "dropdown_after"],
        onChange: function(value) {
            if (value != null && value != "" && value != 0 && acuarlizar) {
                var form_get = new FormData();
                form_get.append("IDPROD", $("#PRODUCTO").val());
                form_get.append("IDCTE", "<?php echo $IDCTE; ?>");
                form_get.append("MONEDA", value);
                $.ajax({
                    type: "POST",
                    url: "requires/cot_partidas.php?GET=PRODUCTO",
                    data: form_get,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        try {
                            var data = JSON.parse(response);
                            $("#PRECIO").val(data.PRECIO);
                            $("#DESCRIPCION").val(data.DESCRIPCION);
                            $("#CANTIDAD").val(data.CANTIDAD);
                            setOption("UNIDAD", data.UNIDAD);
                        } catch (error) {
                            console.error(error);
                        }
                    }
                });
            } else {
                if (value == 0) {
                    reiniciar_formulario(formID);
                }
            }
        }
    });


    $('#RETENCION').keypress(function(event) {
        if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });

    $('#IVA').keypress(function(event) {
        if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });

    $('#CANTIDAD').keypress(function(event) {
        if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });

    $('#PRECIO').keypress(function(event) {
        if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
            event.preventDefault();
        }
    });
</script>

<script>
    var activo_moneda = false;

    function open_modal_crear(accion, id = 0) {
        activo_moneda = false;
        $("#ACCION").val(accion);
        $("#titulo_<?php echo $modal_id; ?>").text("Nueva partida");
        if (accion == "EDITAR" && id > 0) {
            $("#titulo_<?php echo $modal_id; ?>").text("Editar partida");
            acuarlizar = false;
            var form_post = new FormData();
            form_post.append("ID", id);
            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?GET=PARTIDA",
                data: form_post,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        $("#PRECIO").val(data.PRECIO);
                        $("#DESCRIPCION").val(data.DESCRIPCION);
                        $("#CANTIDAD").val(data.CANTIDAD);
                        $("#TIEMPO").val(data.TIEMPO_ENTREGA);
                        $("#IDDET").val(data.IDDET);
                        $("#TCAMBIO").val(data.ELTCAMBIO);
                        $("#IVA").val(data.IVA);
                        $("#RETENCION").val(data.RETENCION);
                        setOption("PRODUCTO", data.IDPROD);
                        setOption("MONEDA_PARTIDA", data.LAIDMONEDA);
                        activo_moneda = true;
                        setOption("UNIDAD", data.UNIDAD);
                        modal_crear_partida.show();
                        acuarlizar = true;
                    } catch (error) {
                        acuarlizar = true;
                        console.error(error);
                    }
                }
            });
        } else {
            reiniciar_formulario(formID);
            $("#IVA").val("<?php echo number_format($iva, 2); ?>");
            $("#RETENCION").val("<?php echo number_format($reten, 2); ?>");
            $("#TCAMBIO").val("<?php echo number_format($tcambio, 2); ?>");
            modal_crear_partida.show();
        }
    }

    function guardar() {
        var form_post = new FormData(form);
        if (validar(formID)) {
            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?PARTIDA=SIMON",
                data: form_post,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        actualizar_montos(data.data);
                        alerta(data.message, 'success', 'top-center');

                        modal_crear_partida.hide();
                        reiniciar_formulario(formID);
                        $("#body").load("requires/cot_partidas.php?IDCOT=<?php echo $idcot; ?>&IDORIGEN=<?php echo $OTRA; ?>");
                    } catch (error) {
                        console.error(error);
                    }
                }
            });
        } else {
            marcar_campos(formID);
        }
    }

    function borrarPartida(id) {
        UIkit.modal.confirm('Seguro que quieres eliminar esta partida?', function() {
            var form_post = new FormData();
            form_post.append("IDDET", id);
            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?BORRAR=SIMON",
                data: form_post,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        console.log(data);
                        actualizar_montos(data.data);
                        alerta(data.message, 'success', 'top-center');
                        $("#body").load("requires/cot_partidas.php?IDCOT=<?php echo $idcot; ?>&IDORIGEN=<?php echo $OTRA; ?>");
                    } catch (error) {
                        console.error(error);
                    }
                }
            });
        });
    }

    function inactivarPartida(id, val) {
        var form_post = new FormData();
        form_post.append("IDDET", id);
        form_post.append("VALUE", val);
        $.ajax({
            type: "POST",
            url: "requires/cot_partidas.php?INACTIVAR=SIMON",
            data: form_post,
            processData: false,
            contentType: false,
            success: function(response) {
                try {
                    var data = JSON.parse(response);
                    actualizar_montos(data.data);
                    alerta(data.message, 'success', 'top-center');
                    $("#body").load("requires/cot_partidas.php?IDCOT=<?php echo $idcot; ?>&IDORIGEN=<?php echo $OTRA; ?>");
                } catch (error) {
                    console.error(error);
                }
            }
        });
    }

    function procesar() {
        let partidas = [];
        $("#form_seleccion input[type=checkbox]:checked").each(function() {
            partidas.push(this.value);
        });

        if (partidas.length > 0) {
            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?VERIFICAR_CAMPOS=SIMON",
                data: {
                    IDCOT: <?php echo $idcot; ?>
                },
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        if (data.success == 1) {
                            modal_procesar.show();
                            //alerta(data.message, 'success', 'top-center');
                        } else {
                            alerta(data.message, 'danger', 'top-center');
                        }
                    } catch (error) {
                        console.error(error);
                    }
                }
            });
        } else {
            UIkit.modal.alert('No hay partidas seleccionadas');
        }
    }

    function guardar_procesar() {
        var form_SELEC = new FormData($("#form_procesar")[0]);

        if (validar("form_procesar")) {
            let partidas = [];
            $("#form_seleccion input[type=checkbox]:checked").each(function() {
                partidas.push(this.value);
            });

            form_SELEC.append("PARTIDAS", partidas.join(","));
            form_SELEC.append("IDCOT", "<?php echo $idcot; ?>");

            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?PROCESAR=SIMON",
                data: form_SELEC,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        if (data.success == 1) {
                            document.getElementById('btnVolver').click();
                            alerta(data.message, 'success', 'top-center');
                        } else {
                            alerta(data.message, 'danger', 'top-center');
                        }
                    } catch (error) {
                        console.error(error);
                    }
                }
            });

            modal_procesar.hide();
        } else {
            marcar_campos("form_procesar");
        }
    }

    function llenar(idcte) {
        UIkit.modal.confirm('Esta función llenará la lista con los productos y precios configurados para el cliente de esta cotización, quieres continuar con este proceso?', function() {
            var form_post = new FormData();
            form_post.append("IDCTE", idcte);
            form_post.append("IDCOT", "<?php echo $idcot; ?>");
            form_post.append("IVA", "<?php echo $iva; ?>");
            form_post.append("RETENCION", "<?php echo $reten; ?>");
            $.ajax({
                type: "POST",
                url: "requires/cot_partidas.php?TRAER=SIMON",
                data: form_post,
                processData: false,
                contentType: false,
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        console.log(data);
                        actualizar_montos(data.data);
                        if (data.success == 1) {
                            alerta(data.message, 'success', 'top-center');
                        } else {
                            alerta(data.message, 'danger', 'top-center');
                        }
                        $("#body").load("requires/cot_partidas.php?IDCOT=<?php echo $idcot; ?>&IDORIGEN=<?php echo $OTRA; ?>");
                    } catch (error) {
                        console.error(error);
                    }
                }
            });
        });
    }
</script>

<script>
    function actualizar_montos(data) {
        $("#monto_subtotal").text("$" + data.MONTO_SUBTOTAL);
        $("#monto_iva").text("$" + data.MONTO_IVA);
        $("#monto_retencion").text("$" + data.MONTO_RETENCION);
        $("#monto_total").text("$" + data.MONTO_TOTAL);
    }

    function reiniciar_formulario(formulario) {
        acuarlizar = false;
        var formFields = document.getElementById(formulario).elements;
        if (formFields == null) {

        } else {
            for (var i = 0; i < formFields.length; i++) {
                var field = formFields[i];
                //console.log(field.type);
                //console.log(field.attributes.isrequired.value);
                if (field.name != "" && field.name != null) {
                    if (field.type == "text" || field.type == "number" || field.type == "select-one" || field.type == "file" || field.type == "textarea") {
                        if (field.type == "select-one") {
                            var value = $("#" + field.id + " option:selected").val();
                            if (value > 0 || value != "0") {
                                setOption(field.id, 0);
                            }
                        } else {
                            $("#" + field.id).val("");
                        }
                    }
                }
            }
        }
        $(".required").css("display", "none");
        acuarlizar = true;
    }

    function validar(formulario) {
        var formFields = document.getElementById(formulario).elements;
        var retorno = true;

        if (formFields == null) {
            retorno = false;
        } else {
            for (var i = 0; i < formFields.length; i++) {
                var field = formFields[i];
                //console.log(field.attributes.isrequired.value);
                if (field.name != "" && field.name != null) {
                    if (field.type == "text" || field.type == "number" || field.type == "select-one" || field.type == "file" || field.type == "textarea") {
                        if (field.attributes.isrequired.value == 1) {
                            if (field.type == "select-one") {
                                var value = $("#" + field.id + " option:selected").val();
                                if (value == "" || value == null || value == 0) {
                                    retorno = false;
                                    break;
                                }
                            } else {
                                if (field.value == "" || field.value == null) {
                                    retorno = false;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return retorno;
    }

    function marcar_campos(formulario) {
        var formFields = document.getElementById(formulario).elements;

        if (formFields == null) {

        } else {
            for (var i = 0; i < formFields.length; i++) {
                var field = formFields[i];
                //console.log(field.attributes.isrequired.value);
                if (field.name != "" && field.name != null) {
                    if (field.type == "text" || field.type == "number" || field.type == "select-one" || field.type == "file" || field.type == "textarea") {
                        if (field.attributes.isrequired.value == 1) {
                            if (field.type == "select-one") {
                                var value = $("#" + field.id + " option:selected").val();
                                if (value == "" || value == null || value == 0) {
                                    $("#required_" + field.id).css("display", "revert");
                                } else {
                                    $("#required_" + field.id).css("display", "none");
                                }
                            } else {
                                if (field.value == "" || field.value == null) {
                                    $("#required_" + field.id).css("display", "revert");
                                } else {
                                    $("#required_" + field.id).css("display", "none");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    //seleciona o establece una option de un select de selectize js
    function setOption(selectID, option_value) {
        //var value = $("#" + field.id + " option:selected").val();
        var idPreselected = option_value;
        var $select = $('#' + selectID).selectize();
        var control = $select[0].selectize;
        control.setValue(idPreselected);
    }


    function convierteMonto(moneda) {
        var precio = $("#PRECIO").val();
        var tipocambio = $("#TCAMBIO").val();
        if (precio > 0 && activo_moneda) {
            //Realizo la conversion
            //Si es mxn, multiplico por el tc
            if (moneda == "1") {
                var total = precio * tipocambio;
            }

            //Si no es mxn, divido por el tc
            if (moneda != "1") {
                var total = precio / tipocambio;
            }

            $("#PRECIO").val(total);
            //console.log(total);

        }

    }
</script>
<!--END MODAL PARTIDA-->
<!--END PARTIDAS-->