<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Obtener IP Local</title>
</head>
<body>
    <script>
        // Función para obtener la dirección IP local del cliente
        function obtenerIPLocal(callback){
            var RTCPeerConnection = window.RTCPeerConnection || window.webkitRTCPeerConnection || window.mozRTCPeerConnection;

            if (RTCPeerConnection) {
                var rtc = new RTCPeerConnection({iceServers: []});

                rtc.createDataChannel('');

                rtc.createOffer(function (offerDesc) {
                    rtc.setLocalDescription(offerDesc);
                }, function (e) { console.warn("Error al crear oferta: " + e); });

                rtc.onicecandidate = function (evt) {
                    if (evt.candidate) {
                        callback(evt.candidate.candidate.split(" ")[4]);
                    }
                };
            } else {
                console.warn("Tu navegador no es compatible con esta técnica para obtener la IP local.");
                callback(null);
            }
        }

        // Uso de la función
        obtenerIPLocal(function(ipLocal){
            if (ipLocal) {
                console.log("La dirección IP local del cliente es: " + ipLocal);
            } else {
                console.log("No se pudo obtener la dirección IP local.");
            }
        });
    </script>
</body>
</html>