<?php 

require_once('Connections/promo.php');

if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
    {
        if (PHP_VERSION < 6) {
            $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
        }

        $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

        switch ($theType) {
            case "text":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue != "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
                break;
            case "date":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
                break;
        }
        return $theValue;
    }
}

mysql_select_db($database_promo, $promo);

// Tu consulta SQL
$query = "SELECT
    CEILING(COUNT(D.IDPROD)/21) AS CUANTOS,
    MMI.mi_long_name,
    HOUR(H.FECHA) AS HORA,
    CASE WHEN MINUTE(H.FECHA) > 0 AND MINUTE(H.FECHA) < 31 THEN '00' ELSE '30' END AS MEDIA
FROM
    TBL_ORDENES_PROD_HEADER H
    LEFT JOIN TBL_ORDENES_PROD_DETAIL D ON D.IDORDEN = H.IDORDEN
    LEFT JOIN mi_menu_items MMI ON MMI.mi_id = D.IDPROD 
WHERE
    (H.FECHA >= CURRENT_DATE - INTERVAL 20 DAY) 
    AND (H.FECHA <= CURRENT_DATE  + INTERVAL 1 DAY) 
    AND D.ELIMINADO = 0 
    AND H.PAGADA = 1 
    AND MMI.IDMODGRUPO IS NULL
    AND MMI.ACTIVO = 1
    AND MMI.COMBO = 0
GROUP BY
    MMI.mi_long_name,   
    HOUR(H.FECHA),
    CASE WHEN MINUTE(H.FECHA) > 0 AND MINUTE(H.FECHA) < 31 THEN 1 ELSE 0 END
ORDER BY
    HOUR(H.FECHA),
    CASE WHEN MINUTE(H.FECHA) > 0 AND MINUTE(H.FECHA) < 31 THEN 1 ELSE 0 END";

// Aquí se asume que ya has obtenido los resultados de la consulta SQL en $result
$result = mysql_query($query, $promo);

// Inicializar un array bidimensional para almacenar los datos
// Inicializar un array bidimensional para almacenar los datos
$data = array();

// Recorrer los resultados de la consulta
while ($row = mysqli_fetch_assoc($result)) {
    $miLongName = $row['mi_long_name'];
    $hora = $row['HORA'];

    $media = $row['MEDIA'];
    $cuantos = $row['CUANTOS'];

    // Crear la clave para la hora y media hora
    $timeKey = $hora . ':' . $media;

    // Almacenar la información en el array
    $data[$miLongName][$timeKey] = $cuantos;
}

// Imprimir la estructura deseada
echo '<table border="1">';
echo '<tr><th>Mi long name</th>';

// Imprimir las horas y medias horas
for ($hour = 0; $hour <= 23; $hour++) {
    for ($minute = 0; $minute <= 30; $minute += 30) {
        $time = sprintf('%02d:%02d', $hour, $minute);
        echo '<th>' . $time . '</th>';
    }
}

echo '</tr>';

// Imprimir los datos
foreach ($data as $miLongName => $times) {
    echo '<tr><td>' . $miLongName . '</td>';

    // Imprimir las horas y medias horas
    for ($hour = 0; $hour <= 23; $hour++) {
        for ($minute = 0; $minute <= 30; $minute += 30) {
            $timeKey = sprintf('%02d:%02d', $hour, $minute);
            echo '<td>' . (isset($times[$timeKey]) ? $times[$timeKey] : '') . '</td>';
        }
    }

    echo '</tr>';
}

echo '</table>';

?>