<?php
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");
require_once("../requires/FuntionsLibrary.php");
require('../TCPDF/tcpdf.php');
//#################################
//MODELS
//#################################
$orden = getResultQuery(
  sprintf(
    "SELECT 
    PH.IDORDEN,
    PH.COMENTARIO,
    O.NOMBRE AS SUCURSAL,
    O.LOGO,
    O.RFC AS RFC_SUCURSAL,
    CL.RFC,
    PH.IDCTE,
    CL.NOMBRE AS RAZON_SOCIAL,
    CL.CALLE, CL.NUMERO, CL.COLONIA, CL.CP, CL.ESTADO, CL.CIUDAD, CL.PAIS,
    COT.OC,
    DC.DESCRIPCION AS DIAS_CREDITO,
      COT.FECHA_ENTREGA,
      PH.FECHA_CREACION AS FECHA_ELABORACION,
      M.MONEDA,
    COALESCE(CONCAT(TDIR.CALLE,',',TDIR.NUM_CALLE,',',TDIR.COLONIA,',',TDIR.CODIGO_POSTAL,',',TDIR.CIUDAD,',',TDIR.ESTADO,',',TDIR.PAIS), '') AS DIRECCIONENVIO
  FROM 
    TBL_ORDENES_PROD_HEADER PH
    LEFT JOIN TBL_COT_HEADER COT ON COT.IDCOT = PH.COT
      LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA=COT.IDMONEDA
    LEFT JOIN TBL_CLIENTES_DIRECCIONES TDIR ON TDIR.IDDIRECCION=COT.IDDIRECCION
    LEFT JOIN TBL_ORIGEN O ON O.IDORIGEN=PH.ORIGEN
    LEFT JOIN TBL_CLIENTES CL ON CL.IDCTE = PH.IDCTE
    LEFT JOIN TBL_DIAS_CREDITO DC ON DC.IDDIAS = COT.DIAS_CREDITO
  WHERE 
    PH.IDORDEN = %s",
    GetSQLValueString($_GET["IDORDEN"], "int")
    )
)[0];

$partidas = getResultQuery(
  sprintf(
    "SELECT
      P.IDPROD AS CODIGO,
      D.CANT AS CANTIDAD,
      D.MONEDA,
      D.UNID AS UNIDAD,
      D.PUNIT AS PRECIO,
      P.DESCRIPCION AS PRODUCTO,
      ( D.PUNIT * D.CANT ) AS TOTAL
      FROM
      TBL_ORDENES_PROD_DETAIL D
      LEFT JOIN TBL_PRODUCTOS P ON P.IDPROD = D.IDPROD 
      WHERE
      D.IDORDEN = %s", 
      GetSQLValueString($_GET["IDORDEN"], "int")
    )
);

$SUBTOTAL = getResultQuery(sprintf(
  "SELECT
  SUM((D.PUNIT * D.CANT)) AS SUBTOTAL
  FROM
  TBL_ORDENES_PROD_DETAIL D 
  WHERE
  D.IDORDEN = %s AND D.MONEDA='MXN'",
  GetSQLValueString($_GET["IDORDEN"], "int")
))[0]["SUBTOTAL"];

$IVA = getResultQuery(sprintf(
  "SELECT
  SUM((D.PUNIT * O.IVA) * D.CANT) AS IVA
  FROM
  TBL_ORDENES_PROD_DETAIL D 
  LEFT JOIN TBL_ORDENES_PROD_HEADER OH ON OH.IDORDEN = D.IDORDEN
  LEFT JOIN TBL_ORIGEN O ON O.IDORIGEN = OH.ORIGEN
  WHERE
  D.IDORDEN = %s AND D.MONEDA='MXN'",
  GetSQLValueString($_GET["IDORDEN"], "int")
))[0]["IVA"];

$TOTAL = $SUBTOTAL+$IVA;

$USD_SUBTOTAL = getResultQuery(sprintf(
  "SELECT
  SUM((D.PUNIT * D.CANT)) AS SUBTOTAL
  FROM
  TBL_ORDENES_PROD_DETAIL D 
  WHERE
  D.IDORDEN = %s AND D.MONEDA='USD'",
  GetSQLValueString($_GET["IDORDEN"], "int")
))[0]["SUBTOTAL"];

$USD_IVA = getResultQuery(sprintf(
  "SELECT
  SUM((D.PUNIT * O.IVA) * D.CANT) AS IVA
  FROM
  TBL_ORDENES_PROD_DETAIL D 
  LEFT JOIN TBL_ORDENES_PROD_HEADER OH ON OH.IDORDEN = D.IDORDEN
  LEFT JOIN TBL_ORIGEN O ON O.IDORIGEN = OH.ORIGEN
  WHERE
  D.IDORDEN = %s AND D.MONEDA='USD'",
  GetSQLValueString($_GET["IDORDEN"], "int")
))[0]["IVA"];

$USD_TOTAL = $USD_SUBTOTAL+$USD_IVA;
//#################################
//VARIABLES
//#################################
$TITULO = "ORDEN-".$_GET["IDORDEN"];
$FILENAME = "ORDEN-".$_GET["IDORDEN"];
$OUTPUT = "I";
$PAGE_ORIENTATION = "H";
$CREDITS = "By www.xnet.mx";
$LOGO = "../".$orden["LOGO"];

$map=function($a,$f){return join("\n",array_map($f,$a));};
//#################################
//HEADER
//#################################
$header_styles = array();
$header = <<<HTML
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>
<body >
    <table width="100%" style="color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 10px; font-weight: 800;">
          <tr>
            <td width="10%">&nbsp;<br><img height="80" src="$LOGO"></td>
            <td width="50%" align="left">
              <table cellpadding="3" style="border-spacing: 5px;">
                <tbody>
                  <tr>
                    <th></th>
                    <th></th>
                  </tr>
                  <tr>
                    <th width="25%"><strong>SUCURSAL</strong></th>
                    <th width="60%" border = "1" style="text-align: center;">${ !${''} = $orden["SUCURSAL"] }</th>
                  </tr>
                  <tr>
                    <th width="25%"><strong>RFC</strong></th>
                    <th width="60%" border = "1" style="text-align: center;">${ !${''} = $orden["RFC_SUCURSAL"] }</th>
                  </tr>
                </tbody>
              </table>
            </td>
            <td width="40%">
                <table style="color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 10px; font-weight: 800;">
                    <tbody><tr>
                        <td align="center"><strong><h1>ORDEN DE PRODUCCION <b style="color:red;">${!${''} = $_GET["IDORDEN"]}</b></h1></strong>
                        <div align="center">Fecha de impresion: ${ !${''} = date("Y-m-d") }</div></td>
                    </tr>				
                </tbody></table>
            </td>
          </tr>
    </table>
<h5>
  <br>
  <table width="100%" cellpadding="2" style="color: #000000; font-family: Arial, Helvetica, sans-serif; font-size: 10px; font-weight: 800;">
    <tbody>
      <tr>
        <th>
          <table cellpadding="3" style="border-spacing: 5px;">
            <tbody>
              <tr>
                <th></th>
                <th></th>
              </tr>
              <tr>
                <th>CODIGO CLIENTE</th>
                <th border = "1" style="text-align: center;">${ !${''} = $orden["IDCTE"] }</th>
              </tr>
              <tr>
                <th></th>
                <th border = "1" style="text-align: center;">${ !${''} = utf8_decode($orden["RAZON_SOCIAL"]) }</th>
              </tr>
              <tr>
                <th></th>
                <th></th>
              </tr>
            </tbody>
          </table>
        </th>
        <th>
          <table cellpadding="3" style="border-spacing: 5px;">
            <tbody>
              <tr>
                <th>FECHA ELABORACION</th>
                <th border = "1" style="text-align: center;">${ !${''} = dateFormat("Y-m-d",$orden["FECHA_ELABORACION"]) }</th>
              </tr>
              <tr>
                <th>FECHA DE ENTREGA</th>
                <th border = "1" style="text-align: center;">${ !${''} = $orden["FECHA_ENTREGA"] }</th>
              </tr>
              <tr>
                <th></th>
                <th border = "1" style="text-align: center;"></th>
              </tr>
              <tr>
                <th>O. COMPRA</th>
                <th border = "1" style="text-align: center;">${ !${''} = $orden["OC"] }</th>
              </tr>
            </tbody>
          </table>
        </th>
      </tr>
      <tr>
        <table cellpadding="3" style="border-spacing: 5px;">
          <tbody>
            <tr>
              <th width="20%">DIRECCION DE ENTREGA</th>
              <th width="80%" border = "1" style="text-align: center;">${ !${''} = utf8_decode($orden["DIRECCIONENVIO"]) }</th>
            </tr>
            <tr>
              <th width="20%">CONDICIONES DE PAGO</th>
              <th width="20%" border = "1" style="text-align: center;">${ !${''} = utf8_decode($orden["DIAS_CREDITO"]) }</th>
            </tr>
          </tbody>
        </table>
      </tr>
    </tbody>
  </table>
</h5>
</body>
</html>
HTML;
//#################################
//BODY
//#################################
$body_styles = array();
$body = <<<HTML
<table cellpadding="8" width="100%" style="font-family: 'Arial, Helvetica, sans-serif'; font-size: 11px; font-weight: 600;">
<thead>
    <tr bgcolor="#EEEEEE">
        <th align="center"><strong>CODIGO</strong></th>
        <th align="center"><strong>DESCRIPCION DE PRODUCTO</strong></th>
        <th align="center"><strong>CANTIDAD</strong></th>
        <th align="center"><strong>PRESENTACION</strong></th>
        <th align="center"><strong>UNIDAD DE MEDIDA</strong></th>
        <th align="center"><strong>PRECIO</strong></th>
        <th align="center"><strong>TOTAL</strong></th>
        <th align="center"><strong>MONEDA</strong></th>
    </tr>
</thead>
<tbody>
  <br>
  {${!${''} = $map($partidas,function($partida){
    return <<<HTML
        <tr>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = $partida["CODIGO"] }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = $partida["PRODUCTO"] }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = number_format(abs($partida["CANTIDAD"]), 2) }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = $partida[""] }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = $partida["UNIDAD"] }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = toMoney($partida["PRECIO"]) }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = toMoney($partida["TOTAL"]) }</td>
          <td style="border-bottom:0.5px dotted #c1c1c1; vertical-align: middle;" align="center">${ !${''} = $partida["MONEDA"] }</td>
      </tr>
HTML;
  })}}
</tbody>
</table>
HTML;
//#################################
//FOOTER
//#################################
$footer_styles = array();
$footer = <<<HTML

HTML;
//#################################
//LAST FOOTER
//#################################
$lastfooter_styles = array();
$lastfooter = <<<HTML
<table width="100%">
	<tbody>
    <tr>
      <td width="80%">
        <table cellpadding="3" width="90%">
          <tbody>
            <tr>
              <th width="20%">OBSERVACIONES</th>
              <th width="80%" border = "1" style="text-align: left;">${ !${''} = utf8_decode($orden["COMENTARIO"]) }</th>
            </tr>
          </tbody>
        </table>
      </td>
      <td width="10%">
       
      </td>
		  <td width="10%" align="right">

      </td>
	  </tr>
  </tbody>
</table>
<br>
<br>
<table width="100%">
  <tr>  
    <td width="50%">
      <table width="100%" cellpadding="2" border="1"  style="color: black; font-family: 'Arial, Helvetica, sans-serif'; font-size: 11px; font-weight: 600; ">
        <tr>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong></strong></th> 
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>TIPO</strong></th>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>CANTIDAD</strong></th>
        </tr>
        <tr>
          <td align="left"><strong>TIPO DE TAPADERA</strong></td>
          <td align="left"><strong></strong></td>
          <td align="left"><strong></strong></td>
        </tr>
        <tr>
          <td align="left"><strong>ETIQUETA</strong></td>
          <td align="left"><strong></strong></td>
          <td align="left"><strong></strong></td>
        </tr>
        <tr>
          <td align="left"><strong>ENVASE</strong></td>
          <td align="left"><strong></strong></td>
          <td align="left"><strong></strong></td>
        </tr>
      </table>
    </td>
    <td width="5%"></td>
    <td width="45%">
    <table width="100%" cellpadding="2" style="color: black; font-family: 'Arial, Helvetica, sans-serif'; font-size: 11px; font-weight: 600; ">
      <tr>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>SUBTOTAL</strong></th>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>IVA</strong></th>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>TOTAL</strong></th>
        <th bgcolor="#EEEEEE" style="text-align: center;"><strong>MONEDA</strong></th>
      </tr>
      <tr>
        <td align="left">${ !${''} = toMoney($SUBTOTAL)}</td>
        <td align="left">${ !${''} = toMoney($IVA)}</td>
        <td align="left">${ !${''} = toMoney($TOTAL)}</td>
        <td align="center">MXN</td>
      </tr>
      <tr>
        <td align="left">${ !${''} = toMoney($USD_SUBTOTAL)}</td>
        <td align="left">${ !${''} = toMoney($USD_IVA)}</td>
        <td align="left">${ !${''} = toMoney($USD_TOTAL)}</td>
        <td align="center">USD</td>
      </tr>
    </table>
    </td>
  </tr>
</table>
HTML;

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF
{

  //Page header

  public function Header()
  {
    global $header;
    $this->SetXY(170, 8);
    $this->SetXY(10, 2);
    $this->writeHTML($header, true, false, false, false, '');
  }

  public function lastPage($resetmargins = false)
  {
    $this->setPage($this->getNumPages(), $resetmargins);
    $this->isLastPage = true;
  }

  // Page footer
  public function Footer()
  {
    global $footer;
    global $lastfooter;
    global $CREDITS;

    if ($this->isLastPage) {
      $this->writeHTML($lastfooter, true, false, false, false, '');
    } else {
      $this->writeHTML($footer, true, false, false, false, '');
    }

    // Position at 15 mm from bottom
    $this->SetY(-15);
    // Set font
    $this->SetFont('helvetica', 'I', 8);
    // Page number
    $this->Cell(0, 10, utf8_decode('Página') . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    $this->Cell(0, 10, $CREDITS, 0, false, 'R', 0, '', 0, false, 'T', 'M');
  }
}



//$tcpdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$tcpdf = new MYPDF((($PAGE_ORIENTATION == "H") ? "L" : "P"), PDF_UNIT, PDF_PAGE_FORMAT, false, 'ISO-8859-1', false);
$tcpdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
// set title of pdf
$tcpdf->SetTitle($TITULO);
// set margins
$tcpdf->SetMargins(10, 85, 10);
$tcpdf->SetHeaderMargin(10);
$tcpdf->SetFooterMargin(50);
// set header and footer in pdf
$tcpdf->setPrintHeader(true);

$tcpdf->setPrintFooter(true);
$tcpdf->setListIndentWidth(3);
// set auto page breaks
$tcpdf->SetAutoPageBreak(TRUE, 70);
// set image scale factor
$tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$tcpdf->AddPage();
$tcpdf->SetFont('times', '', 10.5);
//output
$tcpdf->writeHTML($body, true, false, false, false, $body_styles);
$tcpdf->Output($FILENAME . ".pdf", $OUTPUT);
