<?php

require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");

header("Content-Type:   application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=ComisionesVendedores.xls");  //File name extension was wrong
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Cache-Control: private", false);

if (!function_exists("ejecutarQuery")) {
  function ejecutarQuery($query)
  {
    global $xnet;
    global $database_xnet;
    mysql_select_db($database_xnet, $xnet);
    $res = mysql_query($query, $xnet);
    return $res;
  }
}

if (!function_exists("getResultQuery")) {
  function getResultQuery($query, $encode = array())
  {
    global $xnet;
    global $database_xnet;
    mysql_select_db($database_xnet, $xnet);
    $res = mysql_query($query, $xnet) or die(mysql_error());
    $result = array();
    while ($r = mysql_fetch_assoc($res)) {
      foreach ($encode as $kee) {
        if (array_key_exists($kee, $r)) {
          $r[$kee] = utf8_encode(utf8_decode($r[$kee]));
        }
      }
      array_push($result, $r);
    }
    return $result;
  }
}

function stringStartsWith($needle, $haystack)
{
  if (strpos($haystack, $needle) === 0) {
    return true;
  } else {
    return false;
  }
}

?>

<style>
  table,
  th {
    border: 1px solid #ccc;
    border-collapse: collapse;
  }

  .tableHeader {
    background-color: #0C0;
    color: white;
    font-weight: bold;
    padding: 5px;
  }

  .evenRow {
    background-color: #fbe7fa;
  }

  td {
    padding: 15px;
  }
</style>


<!--QUERY-->
<?php
$query = sprintf(
  "SELECT
	U.ID,
	U.NOMBRE AS VENDEDOR,
	U.COMISION,
	F.NUMERO AS FACTURA,
	F.FECHA,
	P.IDPROD,
	P.DESCRIPCION,
	FD.CANT*FD.MONTOU*CASE WHEN F.MONEDA <> 'MXN' THEN F.TIPOCAMBIO ELSE 1 END AS TOTAL_VENDIDO,
	F.MONEDA,
	FD.IDORDEN AS OP,
	COALESCE(CH.FOLIO, 0) AS OC,
	COALESCE(PD.COSTO, P.COSTO, 0)*CASE WHEN PD.MONEDA_COSTO <> 'MXN' THEN PD.TC_COSTO ELSE 1 END AS TOTAL_COSTO,
	PD.MONEDA_COSTO,
  (FD.CANT*FD.MONTOU*CASE WHEN F.MONEDA <> 'MXN' THEN F.TIPOCAMBIO ELSE 1 END) - 
		(COALESCE(PD.COSTO, P.COSTO, 0)*CASE WHEN PD.MONEDA_COSTO <> 'MXN' THEN PD.TC_COSTO ELSE 1 END ) AS TOTAL_UTILIDAD,
	( (FD.CANT*FD.MONTOU*CASE WHEN F.MONEDA <> 'MXN' THEN F.TIPOCAMBIO ELSE 1 END) - 
	(COALESCE(PD.COSTO, P.COSTO, 0)*CASE WHEN PD.MONEDA_COSTO <> 'MXN' THEN PD.TC_COSTO ELSE 1 END ) ) * U.COMISION AS TOTAL_COMISION
FROM
	TBL_FACT_DET FD
	LEFT JOIN TBL_PRODUCTOS P ON P.IDPROD = FD.IDPROD
	LEFT JOIN TBL_ORDENES_PROD_DETAIL PD ON FD.IDORDEN = PD.IDDET
	LEFT JOIN TBL_FACTURAS F ON F.IDFACT = FD.IDFACT
	LEFT JOIN USUARIOS U ON U.ID = F.IDVENDCOMISION
	LEFT JOIN TBL_ORDENES_COMPRA_HEADER CH ON CH.IDORDEN = PD.OC
	LEFT JOIN TBL_ORDENES_COMPRA_DETAIL CD ON CD.OP = PD.IDDET AND CD.IDORDEN = CH.IDORDEN
WHERE
		F.CANCELADA = 0 AND F.IDVENDCOMISION > 0 /*AND PD.COSTO > 0 */ {$filtros}"
);
$comisiones = getResultQuery($query);
?>

<h3>Reporte de comisiones</h3>

<table class="uk-table dataTable" cellspacing="0" width="100%" style="font-size: 14px;">
  <thead>
    <tr>
      <th align="center" class="tableHeader">VENDEDOR</th>
      <th align="center" class="tableHeader">FECHA</th>
      <th align="center" class="tableHeader">IDPROD</th>
      <th align="center" class="tableHeader">DESCRIPCION</th>
      <th align="center" class="tableHeader">OP</th>
      <th align="center" class="tableHeader">FACTURA</th>
      <th align="center" class="tableHeader">OC</th>
      <th align="center" class="tableHeader">MONEDA</th>
      <th align="center" class="tableHeader">TOTAL VENDIDO</th>
      <th align="center" class="tableHeader">TOTAL COSTO</th>
      <th align="center" class="tableHeader">TOTAL UTILIDAD</th>
      <th align="center" class="tableHeader">% COMISION</th>
      <th align="center" class="tableHeader">TOTAL COMISION</th>
    </tr>
  </thead>
  <tbody>
    <?php if (count($comisiones) > 0) { ?>
      <?php foreach ($comisiones as $comision) { 
	  $comision["MONEDA"] = "MXN"; //SIEMPRE PESILLOS
	  ?>
        <tr>
          <td class="tableHeader2" ><?php echo $comision["VENDEDOR"]; ?></td>
          <td class="tableHeader2" ><?php echo $comision["FECHA"]; ?></td>
          <td class="tableHeader2" ><?php echo $comision["IDPROD"]; ?></td>
          <td class="tableHeader2" ><?php echo $comision["DESCRIPCION"]; ?></td>
          <td class="tableHeader2" ><?php echo  $comision["OP"]; ?></td>
          <td class="tableHeader2" ><?php echo $comision["FACTURA"]; ?></td>
           <td class="tableHeader2" ><?php echo $comision["OC"]; ?></td>
           <td class="tableHeader2" ><?php echo $comision["MONEDA"]; ?></td>
          <td class="tableHeader2" ><?php echo "$" . number_format($comision["TOTAL_VENDIDO"], 2); ?></td>
          <td class="tableHeader2" ><?php echo "$" . number_format($comision["TOTAL_COSTO"], 2); ?></td>
          <td class="tableHeader2" ><?php echo "$" . number_format($comision["TOTAL_UTILIDAD"], 2); ?></td>
          <td class="tableHeader2" ><?php echo number_format($comision["COMISION"]*100, 2); ?>%</td>
          <td class="tableHeader2" ><?php echo "$" . number_format($comision["TOTAL_COMISION"], 2); ?></td>
          
         
        </tr>
       <?php } ?>
    <?php } else { ?>
      <tr>
        <td colspan="5" style="text-align:center;">No se han encontrado resultados</td>
      </tr>
    <?php } ?>
  </tbody>
</table>