<?php
require_once("../requires/seguridad.php");
require_once("../requires/funciones.php");
require_once("../requires/xnet.php");

if (!function_exists("ejecutarQuery")) {
    function ejecutarQuery($query)
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet) or die(mysql_error());
        return $res;
    }
}

if (!function_exists("getResultQuery")) {
    function getResultQuery($query)
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet) or die(mysql_error());
        $result = array();
        while ($r = mysql_fetch_assoc($res)) {
            array_push($result, $r);
        }
        return $result;
    }
}

if (!function_exists("getSomethingOfDate")) {
    function getSomethingOfDate($something, $date)
    {
        $marca = strtotime($date);
        return date($something, $marca);
    }
}

function stringContains($needle, $haystack)
{
    return strpos($haystack, $needle) !== false;
}

function isAssoc(array $arr)
{
    if (array() === $arr) return false;
    return array_keys($arr) !== range(0, count($arr) - 1);
}

function getMes($av)
{
    global $meses;
    $retorno = "";
    if ($av != "") {
        foreach ($meses as $mes) {
            if (stringContains($av, $mes["AV"])) {
                $retorno = $mes["MES"];
                break;
            }
        }
    }
    return $retorno;
}

function sortArray($array, $_key, $_sort = SORT_DESC)
{
    $retorno = array();
    foreach ($array as $key => $row) {
        $retorno[$key] = $row[$_key];
    }
    array_multisort($retorno, $_sort, $array);
    return $array;
}

function group($arr, $key)
{
    $result = array();
    foreach ($arr as $element) {
        $result[$element[$key]][] = $element;
    }
    return $result;
}

function objectToArray($o)
{
    $a = array();
    foreach ($o as $k => $v) $a[$k] = (is_array($v) || is_object($v)) ? objectToArray($v) : $v;
    return $a;
}

function estructura()
{
    $json = '
    {
        "name": "-",
        "marker": {
            "symbol": "circle"
        },
        "data": [0,0,0,0,0,0,0,0,0,0,0,0]
    }
    ';
    return objectToArray(json_decode($json));
}

?>

<?php if (isset($_GET["DETALLE"]) && $_GET["DETALLE"] == "SIMON") { ?>
    <?php
    $query = sprintf(
        "SELECT
        TD.IDDET,
        TD.IDORDEN,
        TD.PUNIT,
        TH.FECHA_CREO,
        MONTH ( TH.FECHA_CREO ) AS MES,
        YEAR(TH.FECHA_CREO) AS ANIO,
        DAY(TH.FECHA_CREO) AS DIA,
        TP.NOMBRE AS PROVEEDOR,
        TD.IDPROD,
        TH.IDPROVEEDOR,
        TPP.DESCRIPCION AS PRODUCTO,
        TD.PUNIT AS PRECIO
        FROM
        TBL_ORDENES_COMPRA_DETAIL TD
        LEFT JOIN TBL_ORDENES_COMPRA_HEADER TH ON TH.IDORDEN = TD.IDORDEN 
        LEFT JOIN TBL_PROVEEDORES TP ON TP.IDPROVEEDOR = TH.IDPROVEEDOR
        LEFT JOIN TBL_PRODUCTOS TPP ON TPP.IDPROD = TD.IDPROD
        WHERE
        TD.IDDET = %s
        AND TH.IDORDEN = %s",
        GetSQLValueString($_POST["IDDET"], "int"),
        GetSQLValueString($_POST["IDORDEN"], "int")
    );
    ?>
    <?php $datos = getResultQuery($query)[0]; ?>
    <div class="uk-grid">
        <div class="uk-width-medium-1-1" style="margin-bottom: 10px;">
            <div class="uk-grid">
                <div class="uk-width-1-5"><b>IDPROVEEDOR:</b></div>
                <div class="uk-width-1-5"><?php echo $datos["IDPROVEEDOR"]; ?></div>
                <div class="uk-width-1-5"><b>PROVEEDOR:</b></div>
                <div class="uk-width-2-5"><?php echo $datos["PROVEEDOR"]; ?></div>
            </div>
        </div>
        <div class="uk-width-medium-1-1" style="margin-bottom: 10px;">
            <div class="uk-grid">
                <div class="uk-width-1-5"><b>IDPRODUCTO:</b></div>
                <div class="uk-width-1-5"><?php echo $datos["IDPROD"]; ?></div>
                <div class="uk-width-1-5"><b>PRODUCTO:</b></div>
                <div class="uk-width-2-5"><?php echo $datos["PRODUCTO"]; ?></div>
            </div>
        </div>
        <div class="uk-width-medium-1-1" style="margin-bottom: 10px;">
            <div class="uk-grid">
                <div class="uk-width-1-5"><b>IDORDEN:</b></div>
                <div class="uk-width-1-5"><?php echo $datos["IDORDEN"]; ?></div>
                <div class="uk-width-1-5"><b>PRECIO:</b></div>
                <div class="uk-width-2-5"><?php echo "$ " . number_format($datos["PRECIO"], 2); ?></div>
            </div>
        </div>
        <div class="uk-width-medium-1-1" style="margin-bottom: 10px;">
            <div class="uk-grid">
                <div class="uk-width-1-5"><b>IDDET:</b></div>
                <div class="uk-width-1-5"><?php echo $datos["IDDET"]; ?></div>
            </div>
        </div>
    </div>
    <?php exit; ?>
<?php } ?>

<style>
    .highcharts-figure,
    .highcharts-data-table table {
        min-width: 310px;
        max-width: 800px;
        margin: 1em auto;
    }

    .highcharts-data-table table {
        font-family: Verdana, sans-serif;
        border-collapse: collapse;
        border: 1px solid #ebebeb;
        margin: 10px auto;
        text-align: center;
        width: 100%;
        max-width: 500px;
    }

    .highcharts-data-table caption {
        padding: 1em 0;
        font-size: 1.2em;
        color: #555;
    }

    .highcharts-data-table th {
        font-weight: 600;
        padding: 0.5em;
    }

    .highcharts-data-table td,
    .highcharts-data-table th,
    .highcharts-data-table caption {
        padding: 0.5em;
    }

    .highcharts-data-table thead tr,
    .highcharts-data-table tr:nth-child(even) {
        background: #f8f8f8;
    }

    .highcharts-data-table tr:hover {
        background: #f1f7ff;
    }
</style>
<?php
$IDPROD = (isset($_POST["PRODUCTO"]) && $_POST["PRODUCTO"] != null && $_POST["PRODUCTO"] != "" && $_POST["PRODUCTO"] > 0) ? $_POST["PRODUCTO"] : "";
$DESDE = (isset($_POST["DESDE"]) && $_POST["DESDE"] != null && $_POST["DESDE"] != "" && $_POST["DESDE"] > 0) ? $_POST["DESDE"] : "";
$HASTA = (isset($_POST["HASTA"]) && $_POST["HASTA"] != null && $_POST["HASTA"] != "" && $_POST["HASTA"] > 0) ? $_POST["HASTA"] : "";

$PRODUCTO = "";
if ($IDPROD != "") {
    $query = sprintf(
        "SELECT IDPROD AS ID, DESCRIPCION AS PRODUCTO FROM TBL_PRODUCTOS WHERE IDPROD=%s",
        GetSQLValueString($IDPROD, "int")
    );
    $PRODUCTO = getResultQuery($query)[0];
}
?>

<?php $query = sprintf("SELECT IDPROD AS ID, DESCRIPCION AS PRODUCTO FROM TBL_PRODUCTOS"); ?>
<?php $productos = getResultQuery($query); ?>


<form name="form_filtro" id="form_filtro" onsubmit="return false;">
    <div class="uk-grid">
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>Producto</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <select name="PRODUCTO" id="PRODUCTO">
                        <option value="">Seleccionar...</option>
                        <?php foreach ($productos as $producto) { ?>
                            <?php if ($IDPROD == $producto['ID']) { ?>
                                <option value="<?php echo $producto['ID']; ?>" selected><?php echo $producto["PRODUCTO"]; ?></option>
                            <?php } else { ?>
                                <option value="<?php echo $producto['ID']; ?>"><?php echo $producto['ID'] . " | " . $producto["PRODUCTO"]; ?></option>
                            <?php } ?>
                        <?php } ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>DE</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <input type="text" autocomplete="off" class="md-input" name="DESDE" id="DESDE" value="<?php echo ($DESDE != "") ? $DESDE : date("Y-m") . "-01"; ?>" data-uk-datepicker="{format:'YYYY-MM-DD', i18n: { months:['Enero','Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'], weekdays:['Dom','Lun', 'Mar', 'Mie', 'Jue', 'Vie','Sab'] } }">
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px;">
            <div class="uk-grid">
                <div class="uk-width-medium-1-4" style="display: flex;margin: auto;">
                    <label><b>HASTA</b></label>
                </div>
                <div class="uk-width-medium-3-4">
                    <input type="text" autocomplete="off" class="md-input" name="HASTA" id="HASTA" value="<?php echo ($HASTA != "") ? $HASTA : date("Y-m-d"); ?>" data-uk-datepicker="{format:'YYYY-MM-DD', i18n: { months:['Enero','Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'], weekdays:['Dom','Lun', 'Mar', 'Mie', 'Jue', 'Vie','Sab'] } }">
                </div>
            </div>
        </div>
        <div class="uk-width-medium-1-4" style="margin-bottom: 15px; display: flex;">
            <button style="margin-top: 3px; width: 100%;" class="md-btn md-btn-primary uk-width-medium-1-2" type="button" onclick="filtrar();"><span class="fa fa-search"></span> Filtrar</button>
        </div>
    </div>
</form>
<br>
<br>
<br>
<figure class="highcharts-figure">
    <div id="container"></div>
    <p class="highcharts-description"></p>
</figure>

<script>
    $("#PRODUCTO").selectize({
        create: false,
        plugins: ["restore_on_backspace", "dropdown_after"]
    });
</script>

<script>
    function filtrar() {
        var data = new FormData($("#form_filtro")[0]);
        $.ajax({
            type: "POST",
            url: "grid/grid_report_productos.php",
            data: data,
            processData: false,
            contentType: false,
            success: function(response) {
                $("#grid").html(response);
            }
        });
    }
</script>

<?php
$lista = array();
$listaAux = array();
if ($IDPROD != "" && $DESDE != "" && $HASTA != "") {
    $query = sprintf(
        "SELECT
        TD.IDDET,
        TD.IDORDEN,
        TD.PUNIT,
        TH.FECHA_CREO,
        MONTH ( TH.FECHA_CREO ) AS MES,
	    YEAR(TH.FECHA_CREO) AS ANIO,
	    DAY(TH.FECHA_CREO) AS DIA,
		M.MONEDA
    FROM
        TBL_ORDENES_COMPRA_DETAIL TD
        LEFT JOIN TBL_ORDENES_COMPRA_HEADER TH ON TH.IDORDEN = TD.IDORDEN 
		LEFT JOIN TBL_MONEDAS M ON M.IDMONEDA = TH.IDMONEDA 
    WHERE
        TD.IDPROD = %s
        AND TH.AUTORIZADAGERENCIA = 5
        AND TH.IDSTATUS <> 10
        AND TH.IDORIGEN = %s
        AND TH.FECHA_CREO BETWEEN %s
        AND %s
        GROUP BY M.MONEDA, TD.PUNIT",
        GetSQLValueString($IDPROD, "int"),
        GetSQLValueString($_SESSION["IDORIGEN"], "int"),
        GetSQLValueString($DESDE, "text"),
        GetSQLValueString($HASTA, "text")
    );

    $simulacion = getResultQuery($query);
    // echo count($simulacion);

    /*$simulacion = array(
        array("PUNIT" => 149.49, "FECHA_CREO" => "2020-01-05", "MES" => "1", "ANIO" => "2020", "DIA" => "5"),
        array("PUNIT" => 83.45, "FECHA_CREO" => "2021-04-05", "MES" => "4", "ANIO" => "2021", "DIA" => "5"),
        array("PUNIT" => 134.64, "FECHA_CREO" => "2022-08-10", "MES" => "8", "ANIO" => "2022", "DIA" => "10"),
        array("PUNIT" => 134.71, "FECHA_CREO" => "2020-02-01", "MES" => "2", "ANIO" => "2020", "DIA" => "1"),
        array("PUNIT" => 75.16, "FECHA_CREO" => "2021-06-27", "MES" => "6", "ANIO" => "2021", "DIA" => "27"),
        array("PUNIT" => 197.59, "FECHA_CREO" => "2022-10-17", "MES" => "10", "ANIO" => "2022", "DIA" => "17"),
        array("PUNIT" => 128.30, "FECHA_CREO" => "2021-05-14", "MES" => "5", "ANIO" => "2021", "DIA" => "14"),
        array("PUNIT" => 39.15, "FECHA_CREO" => "2021-03-15", "MES" => "3", "ANIO" => "2021", "DIA" => "15"),
        array("PUNIT" => 2.75, "FECHA_CREO" => "2021-04-25", "MES" => "4", "ANIO" => "2021", "DIA" => "25"),
        array("PUNIT" => 108.20, "FECHA_CREO" => "2023-04-08", "MES" => "4", "ANIO" => "2023", "DIA" => "8"),
        array("PUNIT" => 121.20, "FECHA_CREO" => "2020-11-10", "MES" => "11", "ANIO" => "2020", "DIA" => "10"),
        array("PUNIT" => 162.43, "FECHA_CREO" => "2023-01-13", "MES" => "1", "ANIO" => "2023", "DIA" => "13"),
        array("PUNIT" => 79.78, "FECHA_CREO" => "2020-03-28", "MES" => "3", "ANIO" => "2020", "DIA" => "28"),
        array("PUNIT" => 197.03, "FECHA_CREO" => "2021-02-18", "MES" => "2", "ANIO" => "2021", "DIA" => "18"),
        array("PUNIT" => 199.31, "FECHA_CREO" => "2020-04-21", "MES" => "4", "ANIO" => "2020", "DIA" => "21"),
    );*/

    $simulacion = sortArray($simulacion, "FECHA_CREO", SORT_DESC);

    $simulacion = group($simulacion, "ANIO");

    $temps = array();
    foreach ($simulacion as $s) {
        $temp = group($s, "MES");
        array_push($temps, $temp);
    }

    $series = array();
    $serie = array();

    $series_AUX = array();

    foreach ($temps as $t1) {
        $anio = "";
        for ($i = 1; $i < 13; $i++) {
            # code...
            if (array_key_exists($i . "", $t1)) {
                $t2 = $t1[$i];
                $agregado = false;
                foreach ($t2 as $t3) {
                    if (!$agregado) {
                        $anio = $t3["ANIO"];
                        array_push($serie, array("IDORDEN" => $t3["IDORDEN"], "IDDET" => $t3["IDDET"], "VAL" => doubleval($t3["PUNIT"])));
                        $agregado = true;
                    } else {
                        $nuevaserie = array();
                        $limite = $t3["MES"];
                        for ($x = 1; $x < $limite; $x++) {
                            array_push($nuevaserie, array("IDORDEN" => 0, "IDDET" => 0, "VAL" => 0));
                        }
                        array_push($nuevaserie, array("IDORDEN" => $t3["IDORDEN"], "IDDET" => $t3["IDDET"], "VAL" => doubleval($t3["PUNIT"])));
                        for ($y = $limite; $y < 12; $y++) {
                            array_push($nuevaserie, array("IDORDEN" => 0, "IDDET" => 0, "VAL" => 0));
                        }
                        array_push($series_AUX, array("ANIO" => $t3["ANIO"], "DATA" => $nuevaserie));
                    }
                }
            } else {
                array_push($serie, array("IDORDEN" => 0, "IDDET" => 0, "VAL" => 0));
            }
        }
        array_push($series, array("ANIO" => $anio, "DATA" => $serie, "MONEDA" => $t1["MONEDA"]));
        foreach ($series_AUX as $serie_AUX) {
            # code...
            array_push($series, $serie_AUX);
        }
        $series_AUX = array();
        $serie = array();
    }

    //echo json_encode($series);
    foreach ($series as $ser) {
        $es = estructura();
        $array = array();
        foreach ($ser["DATA"] as $value) {
            array_push($array, $value["VAL"]);
        }
        $es["data"] = $array;
        $es["name"] = $ser["ANIO"];
        array_push($lista, $es);

        $es = estructura();
        $es["data"] = $ser["DATA"];
        $es["name"] = $ser["ANIO"];
        array_push($listaAux, $es);
    }
    //echo json_encode($lista);
}
?>

<script>
    // Data retrieved https://en.wikipedia.org/wiki/List_of_cities_by_average_temperature
    var config = {
        chart: {
            type: 'spline'
        },
        title: {
            text: 'Costo de <?php echo ($PRODUCTO != "") ? $PRODUCTO["PRODUCTO"] : ""; ?>'
        },
        subtitle: {
            text: '<?php echo $DESDE . " / " . $HASTA ?>'
        },
        xAxis: {
            categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
                'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'
            ],
            accessibility: {
                description: 'Meses del año'
            }
        },
        yAxis: {
            title: {
                text: 'Costos'
            },
            labels: {
                formatter: function() {
                    return this.value;
                }
            }
        },
        tooltip: {
            crosshairs: true,
            shared: true
        },
        plotOptions: {
            spline: {
                marker: {
                    radius: 4,
                    lineColor: '#666666',
                    lineWidth: 1
                }
            }
        },
        series: <?php echo (count($lista) > 0) ? json_encode($lista) : json_encode(array(estructura())); ?>
    }

    var chart = Highcharts.chart('container', config);
    //chart.viewData()
</script>

<!--MODAL DETALLES-->
<div class="uk-modal" id="ver_detalle">
    <div class="uk-modal-dialog">
        <button class="uk-modal-close uk-close" type="button"></button>
        <form id="form_ver_detalle">
            <div class="uk-modal-header">
                <h3 class="uk-modal-title" id="titulo_ver_detalle">Detalles</h3>
            </div>
            <div class="uk-modal-body" id="modal_body">

            </div>
            <div class="uk-modal-footer">
                <button type="button" class="uk-float-right md-btn md-btn-flat md-btn-flat-primary" onclick="cerrar()">Cerrar</button>
            </div>
        </form>
    </div>
</div>

<table class="uk-table uk-table-striped uk-table-hover">
    <caption class="highcharts-table-caption">Costo de <?php echo ($PRODUCTO != "") ? $PRODUCTO["PRODUCTO"] : ""; ?></caption>
    <thead>
        <tr>
            <th>Año</th>
            <th>Moneda</th>
            <th>Ene</th>
            <th>Feb</th>
            <th>Mar</th>
            <th>Abr</th>
            <th>May</th>
            <th>Jun</th>
            <th>Jul</th>
            <th>Ago</th>
            <th>Sep</th>
            <th>Oct</th>
            <th>Nov</th>
            <th>Dic</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($listaAux as $item) { ?>
            <tr>
                <td><?php echo $item["name"]; ?></td>
                <td><?php echo $item["MONEDA"]; ?></td>
                <?php foreach ($item["data"] as $data) { ?>
                    <?php if ($data["IDORDEN"] != "0" && $data["IDDET"]) { ?>
                        <td><a href="javascript: void(0)" onclick='detalle2(<?php echo $data["VAL"]; ?>)'><?php echo "$ " . number_format($data["VAL"], 2); ?></a></td>
                    <?php } else { ?>
                        <td><?php echo "$ " . number_format($data["VAL"], 2); ?></td>
                    <?php } ?>
                <?php } ?>
            </tr>
        <?php } ?>
    </tbody>
</table>

<script>
    var modal_ver_detalle = UIkit.modal("#ver_detalle");

    function detalle(idorden, iddet) {
        if (idorden != "0" && iddet != "0") {
            var form = new FormData();
            form.append("IDORDEN", idorden);
            form.append("IDDET", iddet);
            $.ajax({
                type: "POST",
                url: "grid/grid_report_productos.php?DETALLE=SIMON",
                data: form,
                processData: false,
                contentType: false,
                success: function(response) {
                    $("#modal_body").html(response);
                    modal_ver_detalle.show();
                }
            });
        }
    }

    function detalle2(PRECIO) {
        abreModal("Ver Detalles - ", "vw/vw_detalles_reporte.php?DESDE=<?php echo $DESDE; ?>&HASTA=<?php echo $HASTA; ?>&PRECIO=" + PRECIO, 900, 900);
    }

    function cerrar() {
        modal_ver_detalle.hide();
    }
</script>