<?php
//Forzar https


if (!function_exists("GetSQLValueString")) {
    /**
     * Undocumented function
     *
     * @param string $theValue valor a convertir
     * @param string $theType tipo de dato [int, double, text, date, long]
     * @param string $theDefinedValue
     * @param string $theNotDefinedValue
     * @return void
     */
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
    {
        if (PHP_VERSION < 6) {
            $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
        }

        $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);

        switch ($theType) {
            case "text":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "mysql":
                $theValue = ($theValue != "") ? "`" . $theValue . "`" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue != "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
                break;
            case "date":
                $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
                break;
        }
        return $theValue;
    }
}

if (!function_exists("ejecutarQuery")) {
    /**
     * ejecuta un query
     *
     * @param string $query query mysql a ejecutar
     * @return void
     */
    function ejecutarQuery($query)
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet);
        return $res;
    }
}

if (!function_exists("getResultQuery")) {
    /**
     * ejecuta un query y devuelve un array con los resultados
     *
     * @param string $query query mysql a ejecutar
     * @param array $encode array de campos a codificar en utf8
     * @return array resultados del query
     */
    function getResultQuery($query, $encode = array())
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query($query, $xnet) or die(mysql_error());
        $result = array();
        while ($r = mysql_fetch_assoc($res)) {
            foreach ($encode as $kee) {
                if (array_key_exists($kee, $r)) {
                    $r[$kee] = utf8_encode(utf8_decode($r[$kee]));
                }
            }
            array_push($result, $r);
        }
        return $result;
    }
}

if (!function_exists("formatDate")) {
    /**
     * formatea la fecha con nombre del dia, nombre del mes
     *
     * @param string $date fecha a formatear
     * @return string fecha en formato [dia numero de mes del año] 
     */
    function formatDate($date)
    {
        $marca = strtotime($date);
        $diassemana = array("Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sábado");
        $meses = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
        return $diassemana[date('w', $marca)] . " " . date('d', $marca) . " de " . $meses[date('n', $marca) - 1] . " del " . date('Y', $marca);
    }
}

if (!function_exists("dateFormat")) {
    /**
     * formatea una fecha
     *
     * @param string $format formato
     * @param string $date date
     * @return date Fecha formateada
     */
    function dateFormat($format, $date)
    {
        $marca = strtotime($date);
        return date($format, $marca);
    }
}

if (!function_exists("formatTime")) {
    /**
     * formatea la hora proporcionada
     *
     * @param string $date fecha o hora
     * @return date hora en formato [hora:minutos meridiano]
     */
    function formatTime($date)
    {
        $marca = strtotime($date);
        return date('h:i A', $marca);
    }
}

if (!function_exists("setStartRollBack")) {
    /**
     * establece un punto en el codigo donde iniciará el rollback
     *
     * @return void
     */
    function setStartRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("START TRANSACTION;", $xnet) or die(mysql_error());
        return $res;
    }
}

if (!function_exists("doRollBack")) {
    /**
     * establece el punto final y hace el rollback
     *
     * @return void
     */
    function doRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("ROLLBACK;", $xnet) or die(mysql_error());
        return $res;
    }
}

if (!function_exists("doCommitRollBack")) {
    /**
     * acepta los cambios y descarta el rollback
     *
     * @return void
     */
    function doCommitRollBack()
    {
        global $xnet;
        global $database_xnet;
        mysql_select_db($database_xnet, $xnet);
        $res = mysql_query("COMMIT;", $xnet) or die(mysql_error());
        return $res;
    }
}


//##########################################################################
//funciones extras
if (!function_exists("stringIsEmpty")) {
    /**
     * define si una cadena de texto esta vacia
     *
     * @param string $string cadena de texto
     * @return boolean
     */
    function stringIsEmpty($string)
    {
        return ($string != null && $string != "") ? false : true;
    }
}

if (!function_exists("stringContains")) {
    /**
     * define si una cadena de texto contiene cierta palabra o frase
     *
     * @param string $needle palabra o frase
     * @param string $haystack cadena de texto en la que se buscara la palabra o frase
     * @return boolean
     */
    function stringContains($needle, $haystack)
    {
        return strpos($haystack, $needle) !== false;
    }
}

if (!function_exists("isTimeBetween")) {
    /**
     * define si una hora se encuentra entre dos horas distintas
     *
     * @param string $time Fecha con hora  o solo la hora en formato h:i
     * @param string $start Fecha con hora  o solo la hora en formato h:i desde
     * @param string $end Fecha con hora  o solo la hora en formato h:i hasta
     * @return boolean
     */
    function isTimeBetween($time, $start, $end)
    {
        $date1 = DateTime::createFromFormat('h:i a', $time);
        $date2 = DateTime::createFromFormat('h:i a', $start);
        $date3 = DateTime::createFromFormat('h:i a', $end);
        return ($date1 > $date2 && $date1 < $date3) ? true : false;
    }
}

if (!function_exists("isDateBetween")) {
    /**
     * define si una fecha se encuentra entre dos fechas
     *
     * @param string $time fecha intermediaria
     * @param string $start desde
     * @param string $end hasta
     * @return boolean
     */
    function isDateBetween($time, $start, $end)
    {
        $date1 = strtotime($time);
        $date2 = strtotime($start);
        $date3 = strtotime($end);
        return ($date1 >= $date2 && $date1 <= $date3) ? true : false;
    }
}

if (!function_exists("stringStartsWith")) {
    /**
     * define si una cadena de texto comienza con una palabra o frase
     *
     * @param string $needle palabra o frase
     * @param string $haystack cadena de texto a analizar
     * @return boolean 
     */
    function stringStartsWith($needle, $haystack)
    {
        if (strpos($haystack, $needle) === 0) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists("cutString")) {
    /**
     * recorta una cadena de texto
     *
     * @param string $string cadena de texto a recortar
     * @param int $numberOfchars longitud final de la cadena
     * @return string cadena recortada
     */
    function cutString($string, $numberOfchars)
    {
        return (strlen($string) > $numberOfchars) ? substr($string, 0, ((strlen($string) - $numberOfchars) * -1)) . "..." : $string;
    }
}

if (!function_exists("objectToArray")) {
    /**
     * Convierte un objeto en array
     *
     * @param object $o objeto a convertir
     * @return array arreglo
     */
    function objectToArray($o)
    {
        $a = array();
        foreach ($o as $k => $v) $a[$k] = (is_array($v) || is_object($v)) ? objectToArray($v) : $v;
        return $a;
    }
}

if (!function_exists("isAssoc")) {
    /**
     * checa si un array es asocitivo o no
     *
     * @param array $arr array a checar
     * @return boolean
     */
    function isAssoc(array $arr)
    {
        if (array() === $arr) return false;
        return array_keys($arr) !== range(0, count($arr) - 1);
    }
}

if (!function_exists("dateToTimestamp")) {
    /**
     * convierte date a timestamp
     *
     * @param string $date fecha
     * @return string timestamp
     */
    function dateToTimestamp($date = "")
    {
        if ($date == "") {
            $today = date("Y-m-d H:i:s");
            $d = DateTime::createFromFormat('Y-m-d H:i:s', $today);
            if ($d === false) {
                return 0;
            } else {
                return $d->getTimestamp();
            }
        } else {
            $d = DateTime::createFromFormat('Y-m-d H:i:s', $date);
            if ($d === false) {
                return 0;
            } else {
                return $d->getTimestamp();
            }
        }
    }
}

if (!function_exists("timestampToDate")) {
    /**
     * Convierte timestamp a date
     *
     * @param mixed $timestamp
     * @return date fecha
     */
    function timestampToDate($timestamp)
    {
        return date("Y-m-d H:i:s", $timestamp);
    }
}

if (!function_exists("paramsToString")) {
    /**
     * devuelve una cadena con parametros listos para concatenar a una url y enviar por get
     *
     * @param array $array array asociativo 
     * @return string
     */
    function paramsToString($array)
    {
        $return = "";
        foreach ($array as $key => $value) {
            $return .= sprintf("%s=%s&", $key, $value);
        }
        $return = ($return != "") ? "?" . substr($return, 0, -1) : "";
        return $return;
    }
}

if (!function_exists('toMoney')) {
    function toMoney($val, $symbol = '$', $r = 2)
    {
        $n = $val;
        $sign = ($n < 0) ? '-' : '';
        $i = number_format(abs($n), $r);

        return  $symbol . $sign . $i;
    }
}

if (!function_exists('randomDate')) {
    function randomDate($start_date, $end_date)
    {
        // Convert to timetamps
        $min = strtotime($start_date);
        $max = strtotime($end_date);

        // Generate random number using above bounds
        $val = rand($min, $max);

        // Convert back to desired date format
        return date('Y-m-d H:i:s', $val);
    }
}
