<?php
require_once("./seguridad.php");
require_once("./xnet.php");
require_once("./FuntionsLibrary.php");

if (isset($_POST["IDCOT"])) {
    $IDCOT = $_POST["IDCOT"];
    setStartRollBack(); //ESTABLECE EL PUNTO INICIAL PARA HACER ROLLBACK EN CASO DE ERRORES
    $query = sprintf(
        "INSERT INTO TBL_COT_HEADER (
            IDORIGEN,
            IDCTE,
            IDPROD,
            TIPOCAMBIO,
            IDMONEDA,
            COMENTARIO,
            SOLICITADO_POR,
            ETAPA,
            FECHA_CREACION,
            FECHA_MODIFICACION,
            USUARIOMOD,
            USUARIOCREO,
            ACTIVO,
            MONTO_SUBTOTAL,
            MONTO_RETENCION,
            MONTO_TOTAL,
            MONTO_IVA,
            IVA,
            RETENCION,
            IDVENDEDOR,
            PROCESADA,
            IS_CLON,
            ORIGINAL,
			OCULTA_TOTAL,
            TIEMPO_ENTREGA,
			OC
        ) SELECT
        IDORIGEN,
        IDCTE,
        IDPROD,
        TIPOCAMBIO,
        IDMONEDA,
        COMENTARIO,
        SOLICITADO_POR,
        1,
        FECHA_CREACION,
        FECHA_MODIFICACION,
        USUARIOMOD,
        USUARIOCREO,
        ACTIVO,
        MONTO_SUBTOTAL,
        MONTO_RETENCION,
        MONTO_TOTAL,
        MONTO_IVA,
        IVA,
        RETENCION,
        IDVENDEDOR,
        0,
        1 AS IS_CLON,
        IDCOT AS ORIGINAL,
		OCULTA_TOTAL,
        TIEMPO_ENTREGA,
		OC
        FROM
            TBL_COT_HEADER 
        WHERE
            IDCOT = %s",
        GetSQLValueString($IDCOT, "int")
    );
    $clonar = ejecutarQuery($query); //CLONA LA COTIZACION HEADER
    if ($clonar) {
        $query = sprintf("SELECT MAX(IDCOT) AS ID FROM TBL_COT_HEADER LIMIT 1");
        $id = getResultQuery($query)[0]["ID"];
        $query = sprintf(
            "INSERT INTO TBL_COT_DETAIL (
                IDCOT,
                IDPROD,
                PRECIO,
                CANTIDAD,
                DESCRIPCION,
                UNIDAD,
                TIEMPO_ENTREGA,
                MES,
                ANIO,
                CREADO,
                MODIFICADO,
                USUARIOMOD,
                USUARIOCREO,
                ACTIVO,
                IVA,
                RETENCION,
                TOTAL,
                TOTAL_CON_IVA,
                PRECIO_CON_IVA,
                IS_CLON,
                ORIGINAL,
				MONEDA,
				TCAMBIO
            ) SELECT
            %s,
            IDPROD,
            PRECIO,
            CANTIDAD,
            DESCRIPCION,
            UNIDAD,
            TIEMPO_ENTREGA,
            MES,
            ANIO,
            CREADO,
            MODIFICADO,
            USUARIOMOD,
            USUARIOCREO,
            ACTIVO,
            IVA,
            RETENCION,
            TOTAL,
            TOTAL_CON_IVA,
            PRECIO_CON_IVA,
            1 AS IS_CLON,
            IDDET AS ORIGINAL,
			MONEDA,
			TCAMBIO
            FROM
                TBL_COT_DETAIL 
            WHERE
                IDCOT = %s",
            $id,
            GetSQLValueString($IDCOT, "int")
        );
        $clonar = ejecutarQuery($query);
        if ($clonar) {
            doCommitRollBack(); //CONFIRMA LOS CAMBIOS
            echo json_encode(array("success" => 1, "message" => "Cotizacion clonada :: NUEVO IDCOT = ".$id));
        } else {
            doRollBack(); //EJECUTA EL ROLLBACK
            echo json_encode(array("success" => 0, "message" => "Oops!, algo salio mal"));
        }
    } else {
        doRollBack(); //EJECUTA EL ROLLBACK
        echo json_encode(array("success" => 0, "message" => "Oops!, algo salio mal"));
    }
}
